/*
 * 
Programa con Arduino y tarjeta ESP32 que usa bluetooth para controlar un auto remotamente
al cual se le envían comandos para que avance, retroceda, gire a la derecha, a la izquierda
Avance rápido o lento, cambiando la velocidad.
Este ejemplo crea un puente entre El Bluetooth Serial y Classical (SPP)
y también  muestra que el SerialBT tiene las mismas funcionalidades  que el Serial Normal
Usar un SmartPhone con la App Serial Bluetooth Terminal (de Google Play Store) y
configurar sus botones M1 a M6 para enviar en modo texto los numeros del 0 al 5 para
realizar las funciones descritas.
*/

#include "BluetoothSerial.h"

int motD1 = 32;   // Salida, Motor Derecho: 1=avanza. 0=retrocede
int motD2 = 33;   // Salida, Motor Derecho: 0=avanza. 1=retrocede
int motI1 = 25;   // Salida, Motor Izquierdo: 1=avanza. 0=retrocede
int motI2 = 26;   // Salida, Motor Izquierdo: 0=avanza. 1=retrocede
int buzz = 27;    // Buzzer
int antd = 34;    // Entrada sensor antena derecha
int anti = 35;    // Entrada sensor antena izquierda

volatile int interruptCounter;
int totalInterruptCounter;

hw_timer_t * timer = NULL;
portMUX_TYPE timerMux = portMUX_INITIALIZER_UNLOCKED;

#if !defined(CONFIG_BT_ENABLED) || !defined(CONFIG_BLUEDROID_ENABLED)
#error Bluetooth is not enabled! Please run `make menuconfig` to and enable it
#endif

BluetoothSerial SerialBT;

void IRAM_ATTR onTimer() {
  portENTER_CRITICAL_ISR(&timerMux);
  interruptCounter++;
  portEXIT_CRITICAL_ISR(&timerMux);
}

void setup() {
  timer = timerBegin(0, 80, true);
  timerAttachInterrupt(timer, &onTimer, true);
  timerAlarmWrite(timer, 12000000, true);
  timerAlarmEnable(timer);
  
  pinMode(motD1, OUTPUT);
  digitalWrite(motD1, LOW);
  pinMode(motD2, OUTPUT);
  digitalWrite(motD2, LOW);
  pinMode(motI1, OUTPUT);
  digitalWrite(motI1, LOW);
  pinMode(motI2, OUTPUT);
  digitalWrite(motI2, LOW);
  pinMode(buzz, OUTPUT);
  digitalWrite(buzz, LOW);
  pinMode(antd, INPUT);
  pinMode( anti, INPUT);
  
  Serial.begin(115200);
  SerialBT.begin("ESP32_CAR");      //El nombre del auto a controlar

}

void loop() {
    if (digitalRead(antd) == 0) {               // Antena derecha activada
          digitalWrite(motD1, LOW);             // Detiene el carro
          digitalWrite(motD2, LOW);
          digitalWrite(motI1, LOW);
          digitalWrite(motI2, LOW);

          digitalWrite(buzz, HIGH);
          delay(100);                           // beep 100ms      
          digitalWrite(buzz, LOW);

          delay(1000);

          digitalWrite(motD1, LOW);             // M Der y M Izq reversa
          digitalWrite(motD2, HIGH);
          digitalWrite(motI1, LOW);
          digitalWrite(motI2, HIGH);

          delay(750);
          
          digitalWrite(motD1, HIGH);             // M Der avanza y M Izq reversa (Giro)
          digitalWrite(motD2, LOW);
          digitalWrite(motI1, LOW);
          digitalWrite(motI2, HIGH);

          delay(500);
          
          digitalWrite(motD1, HIGH);             // andando...
          digitalWrite(motD2, LOW);
          digitalWrite(motI1, HIGH);
          digitalWrite(motI2, LOW);
      }    

    if (digitalRead(anti) == 0) {               // Antena izquierda activada
          digitalWrite(motD1, LOW);             // M Der y M Izq detenidos
          digitalWrite(motD2, LOW);
          digitalWrite(motI1, LOW);
          digitalWrite(motI2, LOW);

          digitalWrite(buzz, HIGH);             // beep 100ms
          delay(100);
          digitalWrite(buzz, LOW);
          
          delay(1000);

          digitalWrite(motD1, LOW);             // M Der y M Izq retrocede
          digitalWrite(motD2, HIGH);
          digitalWrite(motI1, LOW);
          digitalWrite(motI2, HIGH);

          delay(750);
          
          digitalWrite(motD1, LOW);             // M Der retrocede M Izq avanza (Giro)
          digitalWrite(motD2, HIGH);
          digitalWrite(motI1, HIGH);
          digitalWrite(motI2, LOW);

          delay(500);
          
          digitalWrite(motD1, HIGH);            // Andando...
          digitalWrite(motD2, LOW);
          digitalWrite(motI1, HIGH);
          digitalWrite(motI2, LOW);
      }    

    if (interruptCounter > 0) {                 // bandera = true indica tiempo razonable para
                                                // marcha atras, girar y salir de un callejón
      if ((digitalRead(motD1) != 0) | (digitalRead(motD2) != 0) | (digitalRead(motI1) != 0) | (digitalRead(motI2) != 0)) { 
          digitalWrite(motD1, LOW);
          digitalWrite(motD2, HIGH);
          digitalWrite(motI1, LOW);
          digitalWrite(motI2, HIGH);

          digitalWrite(buzz, HIGH);             // Beep 10 ms
          delay(100);
          digitalWrite(buzz, LOW);

          digitalWrite(motD1, HIGH);
          digitalWrite(motD2, LOW);
          digitalWrite(motI1, HIGH);
          digitalWrite(motI2, LOW);
      }
          interruptCounter = 0;
   }
  
  if (SerialBT.available()){
    char comando = SerialBT.read();
    Serial.write(comando);


    if (comando == 48) {        //Gira a la derecha tecla M1(0) de la App
          digitalWrite(motD1, HIGH);
          digitalWrite(motD2, LOW);
          digitalWrite(motI1, LOW);
          digitalWrite(motI2, HIGH);            //Gira a la derecha
          digitalWrite(buzz, HIGH);
          delay(100);                           // beep 100ms      
          digitalWrite(buzz, LOW);
          delay(500);
          digitalWrite(motD1, HIGH);
          digitalWrite(motD2, LOW);
          digitalWrite(motI1, HIGH);
          digitalWrite(motI2, LOW);             // andando...
          delay(10);
    }
    if (comando == 49) {        //Gira a la izquierda tecla M2(1)
          digitalWrite(motD1, LOW);
          digitalWrite(motD2, HIGH);
          digitalWrite(motI1, HIGH);
          digitalWrite(motI2, LOW);             //Gira a la izquierda
          digitalWrite(buzz, HIGH);
          delay(100);                           // beep 100ms            
          digitalWrite(buzz, LOW);
          delay(500);
          digitalWrite(motD1, HIGH);
          digitalWrite(motD2, LOW);
          digitalWrite(motI1, HIGH);
          digitalWrite(motI2, LOW);             // andando...
          delay(10);
      }
      
    if (comando == 50) {        //Detenido tecla  M3(2)
          digitalWrite(motD1, LOW);
          digitalWrite(motD2, LOW);
          digitalWrite(motI1, LOW);
          digitalWrite(motI2, LOW);             //M1 y M2 detenido
          digitalWrite(buzz, HIGH);
          delay(100);                           // beep 100ms
          digitalWrite(buzz, LOW);
          delay(10);
    }
    
    if (comando == 51) {        //Andando tecla M4(3)
          digitalWrite(motD1, HIGH);
          digitalWrite(motD2, LOW);
          digitalWrite(motI1, HIGH);
          digitalWrite(motI2, LOW);             //M1 y M2 andando...
          digitalWrite(buzz, HIGH);
          delay(100);                           // beep 100ms            
          digitalWrite(buzz, LOW);
          delay(10);
    }
    
    if (comando == 52) {        //Atras tecla M5(4)
          digitalWrite(motD1, LOW);
          digitalWrite(motD2, HIGH);
          digitalWrite(motI1, LOW);
          digitalWrite(motI2, HIGH);             //M1 y M2 hacia atras
          digitalWrite(buzz, HIGH);
          delay(100);                           // beep 100ms
          digitalWrite(buzz, LOW);
          delay(10);
    }

  delay(20);
  }
  delay(20);
}
