//PUZLE SDL__________________________________________
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <time.h>
#include <sys/time.h>

#include <SDL/SDL.h>
#include "SDL/SDL_ttf.h"
#include "SDL/SDL_image.h"
#include "SDL/SDL_mixer.h"

#include "main.h"
#include "xgrafi.h"
#include "define.h"



void Repaint(void);
unsigned int Ctime(void);
int inkeyM();
void printc(int x, int y, char* temp);
void printn(int x, int y, long temp);
void impri(int x, int y, char c);
char *inputc(int x, int y);


void imprixxx(int xi, int yi, int xo, int yo, int w, int h);
void impriZone(int xi, int yi, int xo, int yo, int w, int h);


void puntuar(long pun);
int load_puntos(void);
long puntosMax[6];
char nombresMax[8][6];
long pu;

void ordenar(void);
void printTime(int x, int y);
void avance();

void presentacion(void);
void terminado(void);
void mover(int m);
void desordena(int num);

unsigned char cuadro[20];
unsigned int tiempo,ti,ti1;
int xx,yy,f1=0;

Mix_Music *mus;

//====================JUEGO=======================

int main (int argc, char *argv[])
{
  int quit = 0;
  int SimbolKey;
  int mouse_x,mouse_y;
  int x,z,zz,m;
  
  if (init(640, 480) == 0 ) return 1;
  printf("F1-Pantalla completa\nQ-Salir\nF5-Ayuda numeros\nF12-Reinicio\n");

  SDL_FillRect( screen, NULL, SDL_MapRGB( screen->format, 0x42, 0x73, 0x4A ) );
  if ( SDL_Flip( screen ) == -1 ) return 3;
  if (load_files((char*)"modelo2.jpg", (char*)"modelo1.png", (char*)"setam.ttf") == 0 ) return 2;
    
  load_puntos();
  mus = Mix_LoadMUS("wmusica.mp3");
  puntuar(0);
 
  
 //__________JUEGO______________
INICIO:
	srand(time(NULL));	
	pu=1000;
	presentacion();	
	ordenar();
	desordena(50);
	Repaint();	

	Mix_PlayMusic(mus,-1);
  while ( quit == 0 )
  {
    SDL_Delay(20);
    avance();
    
     x=0;
	 for(z=0;z<20;z++)
		{
		 if(cuadro[z]!=z) x=1;
		 if(cuadro[z]==19) zz=z;
		}
		
	 if(x==0){Mix_PauseMusic(); terminado(); puntuar(pu); goto INICIO;}
	 if(pu<1){Mix_PauseMusic(); puntuar(pu); goto INICIO;}
	 yy=zz/4; xx=zz-yy*4;
	    
    while ( SDL_PollEvent( &event ) )
    {
	  
      switch (event.type)
      {
//       case  SDL_KEYUP:
//          SimbolKey = event.key.keysym.sym;
//          break;
        case  SDL_KEYDOWN:
          SimbolKey = event.key.keysym.sym;

          switch (SimbolKey)
          {
			case  SDLK_q:
			  quit = 1;
			  break;
			case  SDLK_0:
			  Repaint();
			  break;		
            case  SDLK_F1:
#if YesWindows
              screen = SDL_SetVideoMode( SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP, SDL_FULLSCREEN | SDL_SWSURFACE );
#else
              SDL_WM_ToggleFullScreen(screen);
#endif
              Repaint();
              break;
            case  SDLK_F2:
              screen = SDL_SetVideoMode( SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP, SDL_SWSURFACE );
              Repaint();
              break;
            case  SDLK_F5:
              if(f1==0)
				f1=1;
				else
				f1=0;
              break;
            case  SDLK_F12:
				Mix_PauseMusic();
				goto INICIO;
              break;
          }

          break;
        case	SDL_MOUSEBUTTONDOWN: 
			mouse_x=event.button.x;
			mouse_y=event.button.y;	
			zz=mouse_y/96;
			z=mouse_x/160;
			m=zz*4+z;
	#ifdef DEBUG 
			printf("Evento Raton Abajo X=%d Y=%d Nboton=%d\n",xx,yy,m);	
	#endif				
			if( event.button.button == SDL_BUTTON_LEFT ) 
				{	
					mover(m);
					Repaint();
				}			
        break;
        
        case  SDL_QUIT:
          quit = 1;
          break;
      }
    }

  }


  clean_up();
#ifdef DEBUG
  printf("Fin\n");
#endif
	screen = SDL_SetVideoMode( SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP, SDL_SWSURFACE );
  SDL_Delay(100);
  return 0;
}

//______________________________FIN______________________




void avance()
{
	ti=Ctime();	
	if( ti>ti1 || ti+400<ti1 )	
		{
		 ti1=Ctime() + 100;
		 pu--;
		 Repaint();
		}
}

void ordenar(void)
{
  int z;
	for(z=0;z<20;z++)cuadro[z]=z;
}

void desordena(int num)
{
int x,y,z,x1,y1;
	for(;num>0;num--)
		{
		 x=rand()%4; y=rand()%5;		 
		 x1=rand()%4; y1=rand()%5;
		 z=cuadro[y*4+x];
		 cuadro[y*4+x]=cuadro[y1*4+x1];
		 cuadro[y1*4+x1]=z;
		 Repaint();
		 SDL_Delay(20);
		}
}

void mover(int m)
{
int x,y,zz;
	y=m/4;
	x=m-y*4;
	zz=yy*4+xx;
	if(y==yy)
		{
		 if(x<xx) for(;xx>x;xx--,zz--)
						{
						 cuadro[zz]=cuadro[zz-1]; cuadro[zz-1]=19;
						}
		 if(x>xx) for(;xx<x;xx++,zz++)
						{
						 cuadro[zz]=cuadro[zz+1]; cuadro[zz+1]=19;
						}
		}
	if(x==xx)
		{
		 if(y<yy)
			{
			 for(;yy>y;yy--,zz-=4)
				{
				 cuadro[zz]=cuadro[zz-4]; cuadro[zz-4]=19;
				}
			}
		 if(y>yy)
			{
			 for(;yy<y;yy++,zz+=4)
				{
				 cuadro[zz]=cuadro[zz+4]; cuadro[zz+4]=19;

				}
			}
		}
}



void Repaint(void)
{
 int x,y,xx,yy,z;
 
  SDL_WM_SetCaption( "PUZLE_sdl", NULL );
  //apply_surface( 0, 0, background, screen );
  //SDL_FillRect(screen, 0, SDL_MapRGB(screen->format, 0, 0, 0));
	setcolor(255, 255, 0);
	for(y=0;y<5;y++)
		for(x=0;x<4;x++)
			{
				z=cuadro[y*4+x];
				xx=z % 4;
				yy=z/4;				
				impriZone(xx*160,yy*96,x*160,y*96,160,96);		
				if(f1==1)printn(x*160,y*96,z);
				if(z==19) 
					{
						bar(x*160,y*96,x*160+160,y*96+96);
						printTime(x*160+30,y*96+30);
						setcolor(255, 255, 0);
					}
			}
	setcolor(255,0, 0);
	for(x=160;x<640;x+=160)line(x,0,x,479);
	for(y=96;y<480;y+=96)line(0,y,639,y);
			
	SDL_Flip(screen);
}

void printTime(int x, int y)
{
 int z;
 
	for(z=0;z<64;z+=16)  imprixxx(0, 16 , x+z, y+2, 16, 16);	
	setcolor(255,255,0);	
	printn(x+8,y,pu);
	setcolor(255, 0, 0);	
}	


void terminado(void)
{
	int z;
	setcolor(0, 0, 0);  
	for(z=0;z<10;z++)
	{
		//SDL_FillRect(screen,NULL,SDL_MapRGB(screen->format,0,0,0));
		apply_surface( 0, 0, background, screen );
		imprixxx(0,162, 200, 160,219,97);
		SDL_Flip( screen );	
		SDL_Delay(250); 
		apply_surface( 0, 0, background, screen );
		SDL_Flip( screen );	
		SDL_Delay(250); 
	}
}

void presentacion(void)
{
 int z;
	setcolor(0, 0, 0);  
	for(z=0;z<160;z+=5)
	{
		//SDL_FillRect(screen,NULL,SDL_MapRGB(screen->format,0,0,0));
		apply_surface( 0, 0, background, screen );
		imprixxx(11, 45, 98, z, 430, 121);
		SDL_Flip( screen );	
		SDL_Delay(25); 
	}
	SDL_Delay(2000); 
	for(z=160;z<480;z+=5)
	{
		//SDL_FillRect(screen,NULL,SDL_MapRGB(screen->format,0,0,0));
		apply_surface( 0, 0, background, screen );
		imprixxx(11, 45, 98, z, 430, 121);
		SDL_Flip( screen );	
		SDL_Delay(25); 
	}

}



/* ---- devuelve tiempo del sistema ---- */
unsigned int Ctime(void)
{
 struct timeval tv;
 unsigned int z,zz;
	gettimeofday(&tv,NULL);
	z=tv.tv_usec/10000;
	zz=(tv.tv_sec & 0x00fff)*100;
	return(zz+z);
}


void impriZone(int xi, int yi, int xo, int yo, int w, int h)
{
  static SDL_Rect clip[ 1 ];
  clip[ 0 ].x = xi;
  clip[ 0 ].y = yi;
  clip[ 0 ].w = w;
  clip[ 0 ].h = h;
  apply_surfaceB( xo, yo, background, screen, &clip[ 0 ] );
}


void imprixxx(int xi, int yi, int xo, int yo, int w, int h)
{
  static SDL_Rect clip[ 1 ];
  clip[ 0 ].x = xi;
  clip[ 0 ].y = yi;
  clip[ 0 ].w = w;
  clip[ 0 ].h = h;
  apply_surfaceB( xo, yo, dots, screen, &clip[ 0 ] );
}


//______PUNTOS___________

int load_puntos(void)
{
 FILE *pf;
 int z;
 
  if ((pf = fopen("maxi.pun", "rb")) == NULL)
  {
    printf("ERROR en maxi.pun/n");
    return (2);
  }
  else
  {
    z = fread(puntosMax, 20, 1, pf);
    z += fread(nombresMax, 48, 1, pf); 
    fclose(pf);
  }
 return(0);
}

void puntuar(long pun)
{
  int x, xx, z, c, cc;
  char temporal[20];
  FILE *pf;
  
  setcolor(0, 0, 0);
  bar(0, 0, 800, 600);

  if (pun > puntosMax[4] )
  {
    puntosMax[4] = pun;
    setcolor(0, 0, 0);        bar(0, 0, 800, 600);
    setcolor(255, 255, 0);    printc(100, 80, (char*)"RECORD ESCRIBE TU NOMBRE");
    SDL_Flip( screen );
    sprintf(temporal, "%s", inputc(140, 120));
    for (c = 0; c < 8; c++) nombresMax[c][4] = 0;
    for (c = 0; c < 8 && temporal[c] != 0 ; c++) nombresMax[c][4] = temporal[c];
    nombresMax[7][4] = 0;
    for (xx = 4; xx > 0; xx--)
    {
      x = xx - 1;
      if (puntosMax[x] < puntosMax[x + 1])
      {
        puntosMax[5] = puntosMax[x];
        puntosMax[x] = puntosMax[x + 1];
        puntosMax[x + 1] = puntosMax[5];
        for (z = 0; z < 8; z++)
        {
          nombresMax[z][5] = nombresMax[z][x];
          nombresMax[z][x] = nombresMax[z][x + 1];
          nombresMax[z][x + 1] = nombresMax[z][5];
        }
      }
    }
    if ((pf = fopen("maxi.pun", "wb")) == NULL)
    {
      printf("Error archivo MAX.PUN");
    }
    else
    {
      z = fwrite(puntosMax, 20, 1, pf);
      z = fwrite(nombresMax, 48, 1, pf);
    }
    fclose(pf);

  }
  setcolor(0, 0, 0);
  bar(0, 0, 640, 480);
  setcolor(255, 0, 0);
  printc(200, 80, (char*)"MAXIMAS PUNTUACIONES");
  printc(200, 96, (char*)"--------------------");
  setcolor(255, 255, 0);
  SDL_Flip( screen );
  z = 2;
  for (x = 0; x < 5; x++)
  {
    z++;
    for (cc = 0; cc < 8; cc++)
    {
      impri((cc * 16 + 210), (x * 16 + 160), nombresMax[cc][x]);
    }
    printn((cc * 16 + 210), (x * 16 + 160), puntosMax[x]);
  }

  SDL_Flip( screen );
  SDL_Delay(2000);
}


//___________Rutinas basicas___________________
int inkeyM()
{
  int tecla;
  SDL_Delay(200);
  while ( SDL_PollEvent( &event ) )
  {
    switch (event.type)
    {
      case  SDL_KEYUP:
        tecla = event.key.keysym.sym;
        //            printf("Evento Tecla UP  %d \n",tecla);
        if (tecla > 96 && tecla < 123) tecla -= 32;
        return (tecla);
        break;
      case  SDL_QUIT:
        return (27);
        break;
    }
  }
  return (0);
}


//__________________________________

void printc(int x, int y, char* temp)
{
  SDL_Surface *message;
  message = TTF_RenderText_Solid( font, temp, ColorDefault );
  apply_surface( x, y, message, screen );
  SDL_FreeSurface(message); 
}

void printn(int x, int y, long temp)
{
  char VARI[20];
  sprintf(VARI, "%d", (int)temp);
  printc(x, y, VARI);
}

void impri(int x, int y, char c)
{
  char VARI[20];
  sprintf(VARI, "%c", c);
  printc(x, y, VARI);
}



/* ---- LEE CADENA DEL TECLADO ----*/

char *inputc(int x, int y)
{

  int zz, n;
  static char VARI[10];

  //  setcolor(0,100,0);
  //  bar(x,y,x+100,y+20);
  //  SDL_Flip( screen );
  n = 0; zz = 0;
  while (zz != 10)
  {
    zz = inkeyM();
    if (zz == 13 || zz == 27) goto fin;
    if (zz != 0)
    {
      setcolor(0, 100, 0);
      bar(x, y, x + 100, y + 20);
      setcolor(255, 255, 255);
      if (zz == 8)
      {
        n--;
        if (n < 0)n = 0;
        VARI[n] = 0;
      }
      else
      {
        VARI[n] = zz; VARI[n + 1] = 0;
        if (n < 6)n++;
      }
      printc(x, y, VARI);
      //        printf("%s\n",VARI);
      SDL_Flip( screen );
    }
  }
fin:
  VARI[n] = 0;
  return (VARI);
}

