//HAM2__________________________________________
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <time.h>
#include <SDL/SDL.h>
#include "SDL/SDL_ttf.h"
#include "SDL/SDL_image.h"
#include "SDL/SDL_mixer.h"

#include "main.h"
#include "xgrafi.h"
#include "objetos.h"


#include "mapas.h"


#define TIEMPO1    7
#define TIEMPO2   8
#define TIEMPO3   1

#define ARRIBA 1
#define ABAJO 2
#define IZQUIERDA 3
#define DERECHA 4
#define PARADO 0


void MiTimer();
int tiempo1 = TIEMPO1, tiempo2 = TIEMPO2, tiempo3 = TIEMPO3;


int inkeyM();
void printc(int x, int y, char* temp);
void printn(int x, int y, long temp);
void impri(int x, int y, char c);
char *inputc(int x, int y);



void Repaint(void);
SDL_Color PuntosColor = { 255, 255, 255 };

void puntuar(long pun);
int load_puntos(void);
long puntosMax[6];
char nombresMax[8][6];


void movMalo3(void);
void movMalo4(void);

void movMalost1(int n);
void movMalost2(int n);


int testKill(void);
void resetDat(int z);
void imprixxx(int xi, int yi, int xo, int yo, int w, int h);
void impriMapaCosas(int xi, int yi);
void impriMapa16(int xi, int yi);
void impriMapa16F(int xi, int yi);
void impriPer(int xi, int yi, int n);
void impriMalo(int x, int y, int n);
int buscarCosas(void);


void animarMuerte(void);
void animarOK(void);



int inix =0;
int iniy =0;

void paintJuego(void);
int xper, yper;
int increx = 0, increy = 0;
int xu = 23, yu = 33;
int estado = 0;

int puntos;
int cosasQuedan;

int pantallaE;

Mix_Chunk *comer1 = NULL;
Mix_Chunk *comer2 = NULL;
Mix_Chunk *comer3 = NULL;
Mix_Chunk *comer4 = NULL;
Mix_Chunk *comer5 = NULL;
Mix_Chunk *amuerte = NULL;
Mix_Chunk *aalegria = NULL;
Mix_Chunk *empezar = NULL;


int xmali[4], ymali[4] , emali[4] , ixmali[4] , iymali[4];
int xus[4], yus[4], dus[4], f1s[4]; 


//====================JUEGO=======================

int main (int argc, char *argv[])
{
  //int z;
  int quit = 0;
  //  Uint8 *teclas;
  int SimbolKey;

printf("-----%s\n",mapax);

  if (init(800, 600) == 0 ) return 1;

  SDL_FillRect( screen, NULL, SDL_MapRGB( screen->format, 0x42, 0x73, 0x4A ) );
  if ( SDL_Flip( screen ) == -1 ) return 3;
  if (load_files((char*)"modelo2.png", (char*)"modelo1.png", (char*)"setam.ttf") == 0 ) return 2;




  comer1 = Mix_LoadWAV( "comer1.wav" );
  comer2 = Mix_LoadWAV( "comer2.wav" );
  comer3 = Mix_LoadWAV( "comer3.wav" );
  comer4 = Mix_LoadWAV( "comer4.wav" );
  comer5 = Mix_LoadWAV( "comer5.wav" );
  amuerte = Mix_LoadWAV( "amuerte.wav" );
  aalegria = Mix_LoadWAV( "aalegria.wav" );
  empezar = Mix_LoadWAV( "empezar.wav" );

  load_puntos();
  puntuar(0);
 // 

  //__________JUEGO______________
INICIO:
  puntos = 0;
  pantallaE=0; 
VOLVER:
  apply_surface( 0, 0, background, screen );
  imprixxx(0,159,240,100,294,180);
  SDL_Flip( screen );
  SDL_Delay(2000);
  resetDat(pantallaE);
  pantallaE++; 
  if(pantallaE>2)pantallaE=0;

  increx = 0;  increy = 0;

  while ( quit == 0 )
  {
    SDL_Delay(20);
    MiTimer();
    while ( SDL_PollEvent( &event ) )
    {
      //      teclas = SDL_GetKeyState(NULL);

      switch (event.type)
      {
        case  SDL_KEYUP:
          SimbolKey = event.key.keysym.sym;
          break;
        case  SDL_KEYDOWN:
          SimbolKey = event.key.keysym.sym;
          increx = 0;
          increy = 0;
          switch (SimbolKey)
          {
            case  SDLK_F1:
#if YesWindows
              screen = SDL_SetVideoMode( SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP, SDL_FULLSCREEN | SDL_SWSURFACE );
#else
              SDL_WM_ToggleFullScreen(screen);
#endif
              Repaint();
              break;
            case  SDLK_F2:
              screen = SDL_SetVideoMode( SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP, SDL_SWSURFACE );
              Repaint();
              break;
            case  SDLK_ESCAPE:
              quit = 1;
              break;
            case SDLK_LEFT:
              increx = -1;
              estado = IZQUIERDA;
              break;
            case SDLK_RIGHT:
              increx = 1;
              estado = DERECHA;
              break;
            case SDLK_UP:
              increy = -1;
              estado = ARRIBA;
              break;
            case SDLK_DOWN:
              increy = 1;
              estado = ABAJO;
              break;
          }

          break;
        case  SDL_QUIT:
          quit = 1;
          break;
      }
    }

    //____________Muerte____-
    if (testKill())
    {
      animarMuerte();      
      puntuar(puntos);
      goto INICIO;
    }
    //___Final de pantalla
    if (cosasQuedan < 1)
    {      
      animarOK();
      goto VOLVER;
    }
  }

  //  salir:
  //Cerrar todo el SDL
  Mix_FreeChunk( comer1);
  Mix_FreeChunk( comer2);
  Mix_FreeChunk( comer3);
  Mix_FreeChunk( comer4);
  Mix_FreeChunk( comer5);
  Mix_FreeChunk( amuerte);
  Mix_FreeChunk( aalegria);
  Mix_FreeChunk( empezar);

  clean_up();
#ifdef DEBUG
  printf("Fin\n");
#endif
  SDL_Delay(100);
  return 0;
}

//____________________FIN____________

void paintJuego(void)
{
  int z;
  char temp[20];
  SDL_Surface *message;

  //  SDL_WM_SetCaption( "RadioARDU_sdl", NULL );
  SDL_FillRect(screen, 0, SDL_MapRGB(screen->format, 0, 0, 0));
  //apply_surface( 0, 0, background, screen );
  impriMapa16(inix, iniy);
  impriMapaCosas(inix - 10, iniy - 20);
  impriPer(xper * 16, yper * 16, 0);

  
  impriMalo(xmali[0] * 16, ymali[0] * 16, 1);
  impriMalo(xmali[1] * 16, ymali[1] * 16, 2);
  impriMalo(xmali[2] * 16, ymali[2] * 16, 3);
  impriMalo(xmali[3] * 16, ymali[3] * 16, 4);

  z = mapax[yper * XMAPA + xper];
  if (z != '0')
  {
    switch (z)
    {
      case '5':
        Mix_PlayChannel( -1, comer1, 0 );
        break;
      case '6':
        Mix_PlayChannel( -1, comer2, 0 );
        break;
      case '7':
        Mix_PlayChannel( -1, comer3, 0 );
        break;
      case '8':
        Mix_PlayChannel( -1, comer4, 0 );
        break;
      case '9':
        Mix_PlayChannel( -1, comer5, 0 );
        break;
    }
    mapax[yper * XMAPA + xper] = '0';
    puntos++;
    cosasQuedan = buscarCosas();
    //   printf("PUNTOS %d    QUEDAN %d\n",puntos,cosasQuedan);
  }
  sprintf(temp, "PUNTOS %d  ", puntos);
  message = TTF_RenderText_Solid( font, temp, PuntosColor );
  apply_surface( 60, 565, message, screen );

  sprintf(temp, "RECORD %d  ", (int)puntosMax[0]);
  message = TTF_RenderText_Solid( font, temp, PuntosColor );
  apply_surface( 600, 565, message, screen );

  SDL_Flip( screen );
}



//_______________=====================
void Repaint(void)
{
  SDL_WM_SetCaption( "COCINERO_sdl", NULL );
  //apply_surface( 0, 0, background, screen );
  SDL_FillRect(screen, 0, SDL_MapRGB(screen->format, 0, 0, 0));
  impriMapa16(inix, iniy);
  impriMapaCosas(inix - 10, iniy - 20);
  impriPer(xper * 16, yper * 16, 0);
  SDL_Flip( screen );
}



void MiTimer()
{
  tiempo1--;
  tiempo2--;
  tiempo3--;

  int z;


  // cada __tiempo1
  if (tiempo1 < 0)
  {
    tiempo1 = TIEMPO1;
#ifdef DEBUG
    printf("Tiempo1\n");
#endif

    xu = xper;
    yu = yper;
    xper += increx;
    yper += increy;
    z = yper * XMAPA + xper;

if(xper>49) xper=49;
if(yper>35) yper=35;
if(xper<0)xper=0;
if(yper<0)yper=0;

/*
printf("QUE=%d\n",mapaxx[z]);
*/
    if (z < (int)mapaN && mapaxx[z] >= '0' && mapaxx[z] <= '9')
    {

    }
    else
    {
      xper = xu;
      yper = yu;
      estado = PARADO;
      increx = 0;
      increy = 0;
    }
    
  }

  // cada __tiempo2
  if (tiempo2 < 0)
  {
    tiempo2 = TIEMPO2;
    
    movMalost1(0);
    movMalost1(1);
    movMalost2(2);
    movMalost2(3);
    
    
#ifdef DEBUG
    printf("Tiempo2\n");
#endif
  }

  // cada __tiempo3
  if (tiempo3 < 0)
  {
    tiempo3 = TIEMPO3;
    paintJuego();
  }
}





//_______FUNCIONES___________________________________________


void animarMuerte(void)
{
 int z;
	Mix_PlayChannel( -1, amuerte, 0 );
      for (z = 0; z < 10; z++)
      {
        SDL_FillRect(screen, 0, SDL_MapRGB(screen->format, 0, 0, 0));
        imprixxx(127, 58, inix + xper * 16 - 8, iniy + yper * 16 - 28, 32, 42);
        SDL_Flip( screen );
        SDL_Delay(300);
        SDL_FillRect(screen, 0, SDL_MapRGB(screen->format, 0, 0, 0));
        imprixxx(0, 16, inix + xper * 16 - 8, iniy + yper * 16 - 28, 32, 42);
        SDL_Flip( screen );
        SDL_Delay(100);
      }	
}
	
void animarOK(void)
{
 int z;
	  Mix_PlayChannel( -1, aalegria, 0 );

      for (z = 0; z < 10; z++)
      {
        SDL_FillRect(screen, 0, SDL_MapRGB(screen->format, 0, 0, 0));
        imprixxx(0, 16, inix + xper * 16 - 8, iniy + yper * 16 - 28, 32, 42);
        SDL_Flip( screen );
        SDL_Delay(300);
        SDL_FillRect(screen, 0, SDL_MapRGB(screen->format, 0, 0, 0));
        imprixxx(160, 58, inix + xper * 16 - 8, iniy + yper * 16 - 28, 32, 42);
        SDL_Flip( screen );
        SDL_Delay(300);
      }
}

int testKill(void)
{  
  if (xmali[0] == xper && ymali[0] == yper) return (1);
  if (xmali[1] == xper && ymali[1] == yper) return (1);
  if (xmali[2] == xper && ymali[2] == yper) return (1);
  if (xmali[3] == xper && ymali[3] == yper) return (1);
  return (0);
}



void resetDat(int z)
{
 int t;
 
  Mix_PlayChannel( -1, empezar, 0 );
  estado = DERECHA;
  //SDL_FillRect(screen, 0, SDL_MapRGB(screen->format, 0, 0, 0));
  for(t=0;t<50;t++)
      {	  
		  xper=t;
		  setcolor(0,0,0);
		  bar(0,470,800,520);
		  impriPer(t*18,500,0);
		  SDL_Flip( screen );		  
		  SDL_Delay(100);
	  }
  estado =PARADO;
  
  switch (z)
  {
    case 0:      
      xmali[0] = 1; ymali[0] = 2; emali[0] = 1; ixmali[0] = 1; iymali[0] = 0;
      xmali[1] = 36; ymali[1] = 2; emali[1] = 1; ixmali[1] = 1; iymali[1] = 0;
      xmali[2] = 13; ymali[2] = 2; emali[2] = 1; ixmali[2] = 1; iymali[2] = 0;
      xmali[3] = 48; ymali[3] = 2; emali[3] = 1; ixmali[3] = 1; iymali[3] = 0;
      
      xper = 23; yper = 33;
      strncpy(mapaxx, mapa1, mapaN);
      strncpy(mapax, mapac1, mapaN);
      cosasQuedan = 1000;
      printf("Pantalla 0\n");
      
      break;
     case 1:      
      xmali[0] = 6; ymali[0] = 16; emali[0] = 1; ixmali[0] = 1; iymali[0] = 0;
      xmali[1] = 43; ymali[1] = 16; emali[1] = 1; ixmali[1] = 1; iymali[1] = 0;
      xmali[2] = 34; ymali[2] = 16; emali[2] = 1; ixmali[2] = 1; iymali[2] = 0;
      xmali[3] = 36; ymali[3] = 16; emali[3] = 1; ixmali[3] = 1; iymali[3] = 0;
      
      xper = 23; yper = 33;
      strncpy(mapaxx, mapa2, mapaN);
      strncpy(mapax, mapac2, mapaN);
      cosasQuedan = 1000;
      printf("Pantalla 1\n");
      break;
    default:
      case 2:      
      xmali[0] = 1; ymali[0] = 16; emali[0] = 1; ixmali[0] = 1; iymali[0] = 0;
      xmali[1] = 37; ymali[1] = 16; emali[1] = 1; ixmali[1] = 1; iymali[1] = 0;
      xmali[2] = 12; ymali[2] = 16; emali[2] = 1; ixmali[2] = 1; iymali[2] = 0;
      xmali[3] = 48; ymali[3] = 16; emali[3] = 1; ixmali[3] = 1; iymali[3] = 0;
      
      xper = 23; yper = 33;
      strncpy(mapaxx, mapa3, mapaN);
      strncpy(mapax, mapac3, mapaN);
      cosasQuedan = 1000;
      printf("Pantalla 2\n");
      break;
      break;
  }
  
 
}



void imprixxx(int xi, int yi, int xo, int yo, int w, int h)
{
  static SDL_Rect clip[ 1 ];
  clip[ 0 ].x = xi;
  clip[ 0 ].y = yi;
  clip[ 0 ].w = w;
  clip[ 0 ].h = h;
  apply_surfaceB( xo, yo, dots, screen, &clip[ 0 ] );
}





void impriMapaCosas(int xi, int yi)
{
 static int xx,yy;
 static int x,y,z;
 static char c;	
	x=xi;
	y=yi;
	z=0; 
 for(yy=0; yy<36; yy++)
{
  for(xx=0; xx<XMAPA; xx++)
  {
    c=mapax[z];
    if(c!='0')
    {

      switch (c)
      {
      case '5':
        imprixxx(0, 100, x, y, 32, 32);
        break;
      case '6':
        imprixxx(32, 100, x, y, 32, 32);
        break;
      case '7':
        imprixxx(64, 100, x, y, 32, 32);
        break;
      case '8':
        imprixxx(96, 100, x, y, 32, 32);
        break;
      case '9':
        imprixxx(128, 100, x, y, 32, 32);
        break;
      }
    }
    z++;
    x+=16;
  }
  y+=16;
  x=xi;

}

}




void impriMapa16(int xi, int yi)
{
 static int xx,yy;
 static int x,y,z;
 static char c;	
	x=xi;
	y=yi;
	z=0; 
 for(yy=0; yy<36; yy++)
{
  for(xx=0; xx<XMAPA; xx++)
  {
    c=mapaxx[z];
    if(c!=32)
    {
      if (c > '4')c -= 5;
      switch (c)
      {
      case '0':
        imprixxx(0, 0, x, y, 16, 16);
        break;
      case '1':
        imprixxx(16, 0, x, y, 16, 16);
        break;
      case '2':
        imprixxx(32, 0, x, y, 16, 16);
        break;
      case '3':
        imprixxx(48, 0, x, y, 16, 16);
        break;
      case '4':
        imprixxx(64, 0, x, y, 16, 16);
        break;
 
      }
    }
    z++;
    x+=16;
  }
  y+=16;
  x=xi;
}	

}


void impriPer(int xi, int yi, int n)
{
  static int z = 0;
  int zz;


 switch (estado)
  {
    case ABAJO:
        zz = yper & 1;
		if (zz == 1)
			z = 1;
			else
			z = 2;
    break;
    case ARRIBA:
      zz = yper & 1;
      if (zz == 1)
        {z = 9;}
        else
        {z = 8;}
    break;
    case IZQUIERDA:
      zz = xper & 1;
      if (zz == 1)
		{z = 4;}
		else
		{z = 5;}
    break;
    case DERECHA:
      zz = xper & 1;
	   if (zz == 1)
		{z = 6;}
		else
		{z = 7;}
      break;
    case PARADO:
      if (estado == PARADO) z = 0;
      break;
  }


  switch (z)
  {
    case 0:
      imprixxx(0, 16, inix + xi - 8, iniy + yi - 28, 32, 42);
      break;
    case 1:
      imprixxx(32, 16, inix + xi - 8, iniy + yi - 28, 32, 42);
      break;
    case 2:
      imprixxx(64, 16, inix + xi - 8, iniy + yi - 28, 32, 42);
      break;
    case 4:
      imprixxx(96, 16, inix + xi - 8, iniy + yi - 28, 32, 42);
      break;
    case 5:
      imprixxx(128, 16, inix + xi - 8, iniy + yi - 28, 32, 42);
      break;
    case 6:
      imprixxx(0, 58, inix + xi - 8, iniy + yi - 28, 32, 42);
      break;
    case 7:
      imprixxx(32, 58, inix + xi - 8, iniy + yi - 28, 32, 42);
      break;
    case 8:
      imprixxx(64, 58, inix + xi - 8, iniy + yi - 28, 32, 42);
      break;
    case 9:
      imprixxx(96, 58, inix + xi - 8, iniy + yi - 28, 32, 42);
      break;
  }
}



void impriMalo(int x, int y, int n)
{
  x += inix;
  y = y + iniy - 16;
  switch (n)
  {
    case 1:
      imprixxx(0, 132, x, y, 24, 24);
      break;
    case 2:
      imprixxx(24, 132, x, y, 24, 24);
      break;
    case 3:
      imprixxx(48, 132, x, y, 24, 24);
      break;
    case 4:
      imprixxx(72, 132, x, y, 24, 24);
      break;
  }
}


int buscarCosas(void)
{
  int z, cosas;
  cosas = 0;
  for (z = 0; z < (int)mapaN; z++)
  {
    if (mapax[z] < 'a' && mapax[z] > '0') cosas++;
  }
  return (cosas);
}





//========MALOS=====================

int testLugar(int x, int y)
{
  int z;
  z = y * XMAPA + x;
  if (z < (int)mapaN && mapaxx[z] >= '0' && mapaxx[z] <= '9')
  {
    return (1);
  }
  else
  {
    return (0);
  }
}



int getLugar(int x, int y)
{
  return (mapaxx[y * XMAPA + x]);
}

//_Movimientos de malos t1_______
void movMalost1(int n)
{
  int z;

  if ('4' <= getLugar(xmali[n], ymali[n]) || (ixmali[n] == 0 && iymali[n] == 0))
  {
    dus[n] = rand() % 4;
    switch (dus[n])
    {
      case 0:
        if (testLugar(xmali[n] - 1, ymali[n])) {
          ixmali[n] = -1;
          iymali[n] = 0;
          dus[n] = 1;
        }
        break;
      case 1:
        if (testLugar(xmali[n], ymali[n] + 1)) {
          ixmali[n] = 0;
          iymali[n] = 1;
          dus[n] = 2;
        }
        break;
      case 2:
        if (testLugar(xmali[n] + 1, ymali[n])) {
          ixmali[n] = 1;
          iymali[n] = 0;
          dus[n] = 3;
        }
        break;
      case 3:
        if (testLugar(xmali[n], ymali[n] - 1)) {
          ixmali[n] = 0;
          iymali[n] = -1;
          dus[n] = 0;
        }
        break;
    }
  }

  xus[n] = xmali[n];  yus[n] = ymali[n];
  xmali[n] += ixmali[n];  ymali[n] += iymali[n];
  z = ymali[n] * XMAPA + xmali[n];
  if (z < (int)mapaN && mapaxx[z] >= '0' && mapaxx[z] <= '9')
  {  }
  else
  {    xmali[n] = xus[n];  ymali[n] = yus[n];  ixmali[n] = 0;  iymali[n] = 0;  }
}



void movMalost2(int n)
{
  int z;

  if (f1s[n] == 0 && ('4' <= getLugar(xmali[n], ymali[n]) || (ixmali[n] == 0 && iymali[n] == 0)))
  {
    dus[n] = rand() % 4;
    switch (dus[n])
    {
      case 0:
        if (testLugar(xmali[n] - 1, ymali[n])) {
          ixmali[n] = -1;
          iymali[n] = 0;
        }
        break;
      case 1:
        if (testLugar(xmali[n], ymali[n] + 1)) {
          ixmali[n] = 0;
          iymali[n] = 1;
        }
        break;
      case 2:
        if (testLugar(xmali[n] + 1, ymali[n])) {
          ixmali[n] = 1;
          iymali[n] = 0;
        }
        break;
      case 3:
        if (testLugar(xmali[n], ymali[n] - 1)) {
          ixmali[n] = 0;
          iymali[n] = -1;
        }
        break;
    }
  }
  if (xmali[n] == xper)
  {
    f1s[n] = 1;
    ixmali[n] = 0;
    if (ymali[n] < yper) {
      iymali[n] = 1;
    } else {
      iymali[n] = -1;
    }
  }
  if (ymali[n] == yper)
  {
    f1s[n] = 1;
    iymali[n] = 0;
    if (xmali[n] < xper) {
      ixmali[n] = 1;
    }  else  {
      ixmali[n] = -1;
    }
  }
  xus[n] = xmali[n];  yus[n] = ymali[n];
  xmali[n] += ixmali[n];  ymali[n] += iymali[n];
  z = ymali[n] * XMAPA + xmali[n];
  if (z < (int)mapaN && mapaxx[z] >= '0' && mapaxx[z] <= '9')
  {  }
  else
  {    xmali[n] = xus[n];  ymali[n] = yus[n];  ixmali[n] = 0;  iymali[n] = 0; f1s[n] = 0;  }
}




//______PUNTOS___________

int load_puntos(void)
{
 FILE *pf;
 int z;
 
  if ((pf = fopen("maxi.pun", "rb")) == NULL)
  {
    printf("ERROR en maxi.pun/n");
    return (2);
  }
  else
  {
    z = fread(puntosMax, 20, 1, pf);
    z += fread(nombresMax, 48, 1, pf); 
    fclose(pf);
  }
 return(0);
}

void puntuar(long pun)
{
  int x, xx, z, c, cc;
  char temporal[20];
  FILE *pf;
  
  setcolor(0, 0, 0);
  bar(0, 0, 800, 600);

  if (pun > puntosMax[4] )
  {
    puntosMax[4] = pun;
    setcolor(0, 0, 0);        bar(0, 0, 800, 600);
    setcolor(255, 255, 0);    printc(100, 80, (char*)"ESTAS ENTRE LOS CINCO PRIMEROS ESCRIBE TU NOMBRE");
    SDL_Flip( screen );
    sprintf(temporal, "%s", inputc(340, 120));
    for (c = 0; c < 8; c++) nombresMax[c][4] = 0;
    for (c = 0; c < 8 && temporal[c] != 0 ; c++) nombresMax[c][4] = temporal[c];
    nombresMax[7][4] = 0;
    for (xx = 4; xx > 0; xx--)
    {
      x = xx - 1;
      if (puntosMax[x] < puntosMax[x + 1])
      {
        puntosMax[5] = puntosMax[x];
        puntosMax[x] = puntosMax[x + 1];
        puntosMax[x + 1] = puntosMax[5];
        for (z = 0; z < 8; z++)
        {
          nombresMax[z][5] = nombresMax[z][x];
          nombresMax[z][x] = nombresMax[z][x + 1];
          nombresMax[z][x + 1] = nombresMax[z][5];
        }
      }
    }
    if ((pf = fopen("maxi.pun", "wb")) == NULL)
    {
      printf("Error archivo MAX.PUN");
    }
    else
    {
      z = fwrite(puntosMax, 20, 1, pf);
      z = fwrite(nombresMax, 48, 1, pf);
    }
    fclose(pf);

  }
  setcolor(0, 0, 0);
  bar(0, 0, 800, 600);
  setcolor(255, 0, 0);
  printc(280, 80, (char*)"MAXIMAS PUNTUACIONES");
  printc(280, 96, (char*)"--------------------");
  setcolor(255, 255, 0);
  SDL_Flip( screen );
  z = 2;
  for (x = 0; x < 5; x++)
  {
    z++;
    for (cc = 0; cc < 8; cc++)
    {
      impri((cc * 16 + 310), (x * 16 + 160), nombresMax[cc][x]);
    }
    printn((cc * 16 + 310), (x * 16 + 160), puntosMax[x]);
  }

  SDL_Flip( screen );
  SDL_Delay(3000);
}











//___________Rutinas basicas___________________
int inkeyM()
{
  int tecla;
  SDL_Delay(200);
  while ( SDL_PollEvent( &event ) )
  {
    switch (event.type)
    {
      case  SDL_KEYUP:
        tecla = event.key.keysym.sym;
        //            printf("Evento Tecla UP  %d \n",tecla);
        if (tecla > 96 && tecla < 123) tecla -= 32;
        return (tecla);
        break;
      case  SDL_QUIT:
        return (27);
        break;
    }
  }
  return (0);
}


//__________________________________

void printc(int x, int y, char* temp)
{
  SDL_Surface *message;
  message = TTF_RenderText_Solid( font, temp, ColorDefault );
  apply_surface( x, y, message, screen );
  SDL_FreeSurface(message); 
}

void printn(int x, int y, long temp)
{
  char VARI[20];
  sprintf(VARI, "%d", (int)temp);
  printc(x, y, VARI);
}

void impri(int x, int y, char c)
{
  char VARI[20];
  sprintf(VARI, "%c", c);
  printc(x, y, VARI);
}



/* ---- LEE CADENA DEL TECLADO ----*/

char *inputc(int x, int y)
{

  int zz, n;
  static char VARI[10];

  //  setcolor(0,100,0);
  //  bar(x,y,x+100,y+20);
  //  SDL_Flip( screen );
  n = 0; zz = 0;
  while (zz != 10)
  {
    zz = inkeyM();
    if (zz == 13 || zz == 27) goto fin;
    if (zz != 0)
    {
      setcolor(0, 100, 0);
      bar(x, y, x + 100, y + 20);
      setcolor(255, 255, 255);
      if (zz == 8)
      {
        n--;
        if (n < 0)n = 0;
        VARI[n] = 0;
      }
      else
      {
        VARI[n] = zz; VARI[n + 1] = 0;
        if (n < 6)n++;
      }
      printc(x, y, VARI);
      //        printf("%s\n",VARI);
      SDL_Flip( screen );
    }
  }
fin:
  VARI[n] = 0;
  return (VARI);
}
