/* ---- (c) SETA DOMINIO PUBLICO ----- */
/* ---- LINUX LIBSVGA ---------------- */
/* ---- MODO 320x200X256 ------------- */
/* ---- MODIFICADO 29-01-1999 -------- */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "vga.h"
#include "vgagl.h"

/* --- Rutinas bajo nivel --- */

void clear(unsigned char c);
void plot(int x,int y);
int point(int x,int y);
void line(int x,int y,int xx,int yy);
void bar(int x,int y,int xx,int yy);
void loadfont(char nombre[12]);
void impri (int x,int y,unsigned char ca);
void paleta(void);
void paletapal(void);
void paletablock(int n);
void loadpcx(char *nombre);
void mode(int mode_code);
int dmode(void);
int inkey2(void);
int inkey(void);
void waits(int s);
void espera(int s);
unsigned int Ctime(void);
void velocidad(void);
void mouse(int x);
void mouses(int x,int y,int t);
void getblock(int n,int x,int y,unsigned int ancho,unsigned int alto);
void putblock(int n,int x,int y);
void loadblock(int n,char *nombre);
void putz(int n,long xd,long yd,long xs,long ys, long xx, long yy);
void getz(int n,long xd,long yd,long xs,long ys, long xx, long yy);
void getcolors(void);
void fade(int num);

/* --- Rutinas normales --- */
void inputc(int x,int y,char *nombre);
long inputn(int x,int y,char *nombre);
void box(int x,int y,int xx,int yy);
void printc(int x,int y,char *texto);
void printn(int x,int y,long num);
void error(int z);
void Sbeep(unsigned short high);

unsigned char inportb(unsigned short port);
void outportb(unsigned short port, unsigned char value);
/* ---- Rutinas no implementadas ---- */
void sonido(unsigned int frecuencia,unsigned int duracion);



unsigned char *pv,*pv1,*pvx;
unsigned int *pvi,*pvi1;
int INK,PAPER,SPEED,SETIM;
int XMOUSE,YMOUSE,KMOUSE,CMOUSE,MX,MY,MK,IMOUSE=255,PMOUSE=4;
int MOUSE=1;
int FONTX=1,FONTY=1,CX,CY;
FILE *pf;
char VARI[40];
int *VARI0;
unsigned char tabla[2040],pal[800],COLOR[16];
unsigned char tleta[48]= {0,0,0,63,63,63,
			  0,63,63,63,0,63,
			  0,0,63,63,63,0,
			  0,63,0,63,0,0,
			  32,32,32,47,47,47,
			  0,47,47,47,0,47,
			  0,0,47,47,47,0,
			  0,47,0,47,0,0
			  };
unsigned char *grafi[16];
unsigned char *grafip[16];
unsigned char tmouse[64]= {0,0,0,0,0,0,3,3,
			0,1,1,1,1,0,3,3,
			0,1,1,1,0,3,3,3,
			0,1,1,1,0,3,3,3,
			0,1,0,0,1,0,3,3,
			0,0,3,3,0,1,0,3,
			3,3,3,3,3,0,1,0,
			3,3,3,3,3,3,0,0};
unsigned char xmouse[64];

unsigned char sfteclado,agteclado,nuteclado,bmteclado;
unsigned char m0teclado[128] ={
0,27,'1','2','3','4','5','6','7','8','9',
'0',39,173,8,10,'q','w','e','r','t',
'y','u','i','o','p',96,'+',13,0,
'a','s','d','f','g','h','j','k','l',164,39,167,
0,135,'z','x','c','v','b','n','m',44,'.','-',0,
'*',0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,'7','8','9','-',
'4','5','6','+','1','2','3','0','.',0,0,60,
0,0,0,0,0,0,0,0,0,13,0,47,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };

unsigned char m1teclado[128] ={
0,27,33,'"',250,'$','%','&','/','(',')',
'=','?',168,8,10,'Q','W','E','R','T',
'Y','U','I','O','P','^','*',13,0,
'A','S','D','F','G','H','J','K','L',165,34,166,
0,128,'Z','X','C','V','B','N','M',';',':','_',0,
'*',0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,'7','8','9','-',
'4','5','6','+','1','2','3','0','.',0,0,62,
0,0,0,0,0,0,0,0,0,13,0,47,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };


unsigned char m2teclado[128] ={
0,27,'|','@','#','4','5',191,'7','8','9',
'0',39,140,8,10,'q','w','e','r','t',
'y','u','i','o','p',96,'+',13,0,
'a','s','d','f','g','h','j','k','l',164,123,92,
0,125,'z','x','c','v','b','n','m',44,'.','-',0,
'*',0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,'-',
0,0,0,'+',0,0,0,0,0,0,0,60,
0,0,0,0,0,0,0,0,0,13,0,47,
0,0,0,71,72,73,75,77,79,80,81,82,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };



/* ---------------------- SETA G320x200x256 ------------------------- */
/* ---- Rutinas no implementadas ---- */
void sonido(unsigned int frecuencia,unsigned int duracion)
{
 Sbeep(frecuencia);
 espera(duracion);
 Sbeep(0);
}
/* -------------------------------------------------------- */
unsigned char inportb(unsigned short port)
{
unsigned char z;
	__asm__("
	  pushw %%dx\n
	  pushw %%ax\n
	  movw %1,%%dx\n
	  in %%dx,%%al\n
	  movb %%al,%0\n
	  popw %%ax\n
	  popw %%dx"
	  : "=g" (z)
	  :  "g" (port)
	  : "ax","dx"
	);
	return(z);
}

void outportb(unsigned short port, unsigned char value)
{
	__asm__("
	  pushw %%dx\n
	  pushw %%ax\n
	  movw %1,%%dx\n
	  movb %0,%%al\n
	  out %%al,%%dx\n
	  popw %%ax\n
	  popw %%dx"
	  :
	  : "g" (value), "g" (port)
	  : "ax","dx"
	);
} 

void Sbeep(unsigned short high)
{
unsigned char p,cl,ch;

	cl=high & 0x00FF;

	ch=(high>>8) & 0x00FF;

	p = inportb(0x61);
 
	if(high)

		{

		 outportb(0x61,p|3);

		 outportb(0x43,0xb6);

		 outportb(0x42,cl);

		 outportb(0x42,ch);

		}

	 else

		{

		 outportb(0x61,p&0xfc);

		}
}


/* ---- espera un tiempo calculado en 25 cada segundo ---- */
void espera(int s)
{
int z;
	z=s*4;
	z+=(Ctime());
	if(z-Ctime()>250) goto fin;
 	while(Ctime()<z);
fin:
}

/* ---- num<1 aclara-- num>1 oscurece ---num entre 1 y 5 - */
void fade(int num)
{
int z,zz,x,nu,f1;
int pal1[769];
  f1=Ctime();
  for(x=0;x<769;x++) pal1[x]=pal[x];

  if(num>0)
   {
	nu=70-num*13;
	for(z=0;z<nu;z++)
	   {
		for(zz=0;zz<769;zz++) 
			if(pal[zz]>num)pal[zz]-=num; else pal[zz]=0;
		paletapal();
		while(f1==(Ctime()/6));
		f1=(Ctime()/6);
	   }
	 for(x=0;x<769;x++) pal[x]=0;
	 paletapal();
	 for(x=0;x<769;x++) pal[x]=pal1[x];
	}
     else
	{
	num=num*-1;
	for(z=70;z>10;z-=num)
	   {
		for(zz=0;zz<769;zz++) 
			if(pal1[zz]-z>0) pal[zz]=pal1[zz]-z; else pal[zz]=0; 
		paletapal();
		while(f1==Ctime()/6);
		f1=Ctime()/6;
	   }
	 for(x=0;x<769;x++) pal[x]=pal1[x];
	 paletapal();
	}
}

/* ---- devuelve tiempo del sistema ---- */
unsigned int Ctime(void)
{
struct timeval tv;
unsigned int z,zz;
	gettimeofday(&tv,NULL);
	z=tv.tv_usec/10000;
	zz=(tv.tv_sec & 0x00fff)*100;
	return(zz+z);
}

/* --- Coloca los colores definidos en tleta en la cadena COLOR --- */
void getcolors(void)
{
int x,z,zz;
char xr,xv,xa;
 for(x=0;x<16;x++)
	{
	 zz=x*3; xr=tleta[zz]; xv=tleta[zz+1]; xa=tleta[zz+2];
	 for(z=0;z<766;z+=3)
		{
		 if(pal[z]==xr && pal[z+1]==xv && pal[z+2]==xa)
			{ COLOR[x]=z/3; goto salto;}
		}
	 COLOR[x]=254;
salto:
;
	}
}

/*  ------------------------------------------------
	Guarda una zona de la pantalla en la zona (n)
	xd,yd  cordendas de origen pantalla
	xs,ys  cordenadas de destino zona
	xx,yy  tamao de la zona
*/
void getz(int n,long xd,long yd,long xs,long ys, long xx, long yy)
{
long  d,d2;
unsigned int c,cc,z,zz,x1,y1;
unsigned char  *base;
long ancho,alto;
	base=grafi[n];
	if(base==0) goto fin;
	ancho=*base;
	base++;
	z=*base; ancho+=(z<<8);
	base++;
	alto=*base;
	base++;
	z=*base; alto+=(z<<8);
	base++;
	if(xs+xx>ancho || ys+yy>alto) goto fin;
	d2=xs+(ancho*ys);  base+=d2;
	x1=xd+xx; y1=yd+yy;
	zz=ancho-xx;
        z=x1-xd; z=320-z;
        pv=pvx+yd*320+xd;
	for(cc=yd;cc<y1;cc++)
		{
		for(c=xd;c<x1;c++)
			{
			 *base=*pv;
			 base++; pv++;
			}
		base+=zz;  pv+=z;
		}
 fin:
 ;
}

/*  ------------------------------------------------
	imprime una una parte de la zona (n) en pantalla
	xd,yd  cordendas de destino
	xs,ys  cordenadas de fuente
	xx,yy  tamao de la zona
*/
void putz(int n,long xd,long yd,long xs,long ys, long xx, long yy)
{
long  d,d2;
unsigned int c,cc,z,zz,x1,y1;
unsigned char  *base;
long ancho,alto;
	base=grafi[n];
	if(base==0) goto fin;
	ancho=*base;
	base++;
	z=*base; ancho+=(z<<8);
	base++;
	alto=*base;
	base++;
	z=*base; alto+=(z<<8);
	base++;
	if(xs+xx>ancho || ys+yy>alto) goto fin;
	d2=xs+(ancho*ys);  base+=d2;
	x1=xd+xx; y1=yd+yy;
	zz=ancho-xx;
        z=x1-xd; z=320-z;
        pv=pvx+yd*320+xd;
	for(cc=yd;cc<y1;cc++)
		{
		for(c=xd;c<x1;c++)
			{
                         *pv=*base;
			 base++; pv++;
			}
		base+=zz;  pv+=z;
		}
 fin:
 ;
}

/* ---- LEE UN FICHERO PCX A LA MEMORIA ---- */
void loadblock(int n,char *nombre)
{
unsigned int x,xx,z,zz,cx,cy;
unsigned char a,b;
long  d1,d2,dd,me;
unsigned char  *base;

	if ((pf=fopen(nombre,"rb"))==NULL) {error(2); goto fin;}
	x=fread(pal,128,1,pf);
	d1=1+pal[9]*256+pal[8];
	d2=1+pal[11]*256+pal[10];
	if(d1<320)d1+=1;
	me=d1*d2+4;
	if(grafi[n]!=0) free(grafi[n]);
	grafi[n]=malloc(me);
	if(grafi[n]==0){error(8); goto fin;}
	if(grafip[n]!=0) free(grafip[n]);
	grafip[n]=malloc(771);
	if(grafip[n]==0){error(8); goto fin;}
	me-=4;
	base=grafi[n];
	*base=d1&0x00FF;
	base++;
	*base=(d1>>8)&0x00FF;
	base++;
	*base=d2&0x00FF;
	base++;
	*base=(d2>>8)&0x00FF;
	base++;
while(1<2)
	{
	a=getc(pf);
	if(a>192){ b=a-192; a=getc(pf);} else {b=1;}
	while(b!=0){
		   b--;
		   *base=a;
		   base++;
		   me--;
		   if(me<1)goto salto;
		   }
	}
salto:
	a=getc(pf);
	x=fread(pal,769,1,pf);
	base=grafip[n];
	for (x=0;x<769;x++){ pal[x]=pal[x]/4; *base=pal[x]; base++;}
	fclose(pf);
fin:
;
}

void getblock(int n,int x,int y,unsigned int ancho,unsigned int alto)
{
unsigned int c,cc,z;
unsigned char *base;
	c=ancho*alto+4;
	if(grafi[n]!=0) free(grafi[n]);
	grafi[n]=malloc(c);
	if(grafi[n]==0){error(8); goto getfin;}
	base=grafi[n];
	*base=ancho&0x00FF;
	base++;
	*base=(ancho>>8)&0x00FF;
	base++;
	*base=alto&0x00FF;
	base++;
	*base=(alto>>8)&0x00FF;
	base++;
	pv=pvx+y*320+x;
	z=0;
	for(cc=0;cc<alto;cc++)
		{
		for(c=0;c<ancho;c++)
			{
			 *base=*pv;
			 base++; pv++;
			}
		pv=pv-ancho+320;
		}
 getfin:
 ;
}


void putblock(int n,int x,int y)
{
unsigned int c,cc,z,ancho,alto;
unsigned char *base;
	base=grafi[n];
	if(base==0) goto putfin;
	ancho=*base;
	base++;
	z=*base; ancho+=(z<<8);
	base++;
	alto=*base;
	base++;
	z=*base; alto+=(z<<8);
	base++;
	pv=pvx+y*320+x;
	for(cc=0;cc<alto;cc++)
		{
		for(c=0;c<ancho;c++)
			{
			if(x+c<=320) *pv=*base;
			 base++;  pv++;
			}
		pv=pv-ancho+320;
		}
 putfin:
 ;
}

/* --- 1=IMPRIME MOUSE    2=LEE MASCARA    3=ESCRIBE MASCARA --- */

void mouses (int x,int y,int t)
{
unsigned char c,z,zz;

pv=pvx+x+y*320;
pv1=pvx+64000;
zz=0;
  switch(t){
	case 1:
	      for (z=0;z<64;z++)
		{
		 c=tmouse[z];
		 if(c!=3 && pv<pv1)if(c==0) *pv=PMOUSE; else *pv=IMOUSE;
		 zz++;
		 if(zz==8){ pv+=312; zz=0;}
		 pv++;
		}	
		break;
	case 2:
		for (z=0;z<64;z++)
		{
		 xmouse[z]=*pv;
		 zz++;
		 if(zz==8){ pv+=312; zz=0;}
		 pv++;
		}
		break;
	case 3:
		for (z=0;z<64;z++)
		{
		 *pv=xmouse[z];
		 zz++;
		 if(zz==8){ pv+=312; zz=0;}
		 pv++;
		}
		break;
	}
}
/* ------MOUSE ------ */
/*  3-carga datos */
void mouse(int x)
{
  switch(x)
	{
	case 3:
		mouse_update();
		XMOUSE = mouse_getx();
		YMOUSE = mouse_gety();
		KMOUSE = mouse_getbutton();
		if(KMOUSE==1)KMOUSE=2;
		if(KMOUSE==4)KMOUSE=1;
		CMOUSE=0;
		if(MX!=XMOUSE || MY!=YMOUSE || MK!=KMOUSE) CMOUSE=1;
		MX=XMOUSE; MY=YMOUSE; MK=KMOUSE;
		break;
	default: ;
	}
}

void velocidad(void)
{
long Sti;
unsigned ti;
	Sti=0;
	printc(0,0,"ESPERA UN MOMENTO");
	ti=time(NULL);
	while(ti==time(NULL));
	ti=time(NULL);
	while(ti==time(NULL))Sti++;
	SPEED=Sti/1000;
}
/* ---- espera s segundos ---- */
void waits(int s)
{
int z;
	z=s*100;
	z+=(Ctime());
 	while(Ctime()<z);

}
/* ---- devuelve la tecla pulsada ---- */
int inkey2(void)
{
int c,z,zz,t;
struct timeval timeout;
fd_set read_fds;

	FD_ZERO (&read_fds);
	FD_SET (0, &read_fds);
	timeout.tv_sec = 0;
	timeout.tv_usec = 0;
	switch (select (1,&read_fds,(fd_set*)NULL,(fd_set*)NULL, &timeout))
	 {
	  case 0:
	  	 c=0; t=0;
	  	 break;
	  default:
		 read(0,&c,1);
                 c&=255; t=0;
                 switch(c)
                    {
                     case 42:
                        sfteclado=1; break;
                     case 54:
                        sfteclado=1; break;
                     case 58:
                        if(bmteclado==0) bmteclado=1; else bmteclado=0;
                        break;
                     case 69:
                        if(nuteclado==0) nuteclado=1; else nuteclado=0;
                        break;
                     case 100:
                        agteclado=1; break;
                     case 170:
                        sfteclado=0; break;
                     case 182:
                        sfteclado=0; break;
                     case 228:
                        agteclado=0; break;
                     default:
                        if(c&128) break;
                        z=c&0x007f;
                        if(z>101 && z<112){ t=0; c=m2teclado[z]; break;}
                        if(sfteclado==0)t=m0teclado[z]; else t=m1teclado[z];
                        if(agteclado==1)t=m2teclado[z];
                        if(nuteclado==1 && z>70 && z<84) t=m2teclado[z];
                        if(bmteclado==1 && t>96 && t<123) t-=32;
                        break;
                    }
                 c=c<<8; c=c|t;
		 break;
	 }
        
	return(c&0x00FFFF);
}
/* ---- devuelve la tecla pulsada ---- */
int inkey(void)
{
    return(inkey2()&255);
}
/* ---- devuelve el modo de pantalla ---- */
int dmode(void)
{
     return(vga_getcurrentmode());
}
/* ---- modo de pantalla ---- */
void mode(int mode_code)
{
 if(mode_code<4)
 	{
 	 free(VARI0);
         keyboard_close();
 	 if(MOUSE==1)
 	  {
 	    #ifdef MANUALLY_SETUP_MOUSE
    		mouse_close();
	    #endif 
	  }
 	 vga_setmode(TEXT);
 	}
 	else
 	{
 	 VARI0=malloc(5000);
 	 vga_init();
 	 if(MOUSE==1)
    	     { 
    	      #ifndef MANUALLY_SETUP_MOUSE
    		vga_setmousesupport(1);
	      #endif
	     } 
	vga_setmode(G320x200x256);
	gl_setcontextvga(G320x200x256);
    	gl_enableclipping();
	if(MOUSE==1)
    	  { 
	   #ifdef MANUALLY_SETUP_MOUSE
	    mouse_init("/dev/mouse", MOUSE_MICROSOFT, MOUSE_DEFAULTSAMPLERATE);
	    mouse_setxrange(0, WIDTH - 1);
	    mouse_setyrange(0, HEIGHT - 1);
	    mouse_setwrap(MOUSE_NOWRAP);
	   #endif
	  } 
    	 pvx=VBUF;
    	 keyboard_init();
 	}
}
/* ---- LEE UNA IMAGEN EN LA PANTALLA ---- */
void loadpcx(char *nombre)
{

unsigned int x,z;
unsigned char a,b;

	if ((pf=fopen(nombre,"rb"))==NULL) { error(2); goto fin;}
	for(x=0;x<769;x++) pal[x]=0;
	paletapal();
	z=0; pv=pvx;
	x=fread(pal,128,1,pf);
	for(x=0;x<63999;x++)
		{
		a=getc(pf);
		if(a>192)
			{ b=a-192; a=getc(pf);	 }
		  else
		 	{ b=1;	 }
		while(b!=0)
			   {
			   *pv=a;
			   b--; pv++; z++;
			   if(z>63999)goto salto;
			   }
		}
salto:
	x=fseek(pf,-768L,2);
	x=fread(pal,769,1,pf);
	for(z=0;z<769;z++)pal[z]=pal[z]>>2;
	paletapal();
	fclose(pf);
fin:
;
}
/*---- coloca paleta por defecto ----*/
void paleta()
{
 int z;
	pvi=VARI0; 
	 pvi1=pvi;
 	 for(z=0;z<48;z++){ *pvi1=tleta[z]; pvi1++; }
 	 vga_setpalvec(0,16,pvi);
}
/* ---- coloca la paleta situada en la variable pal ---- */
void paletapal(void)
{
int z;
	pvi=VARI0;
	 pvi1=pvi;
 	 for(z=0;z<769;z++){ *pvi1=pal[z];  pvi1++;}
 	 vga_setpalvec(0,256,pvi);
}
/* ---- coloca la paleta del bloque n --- */
void paletablock(int n)
{
unsigned char *base;
int x;
	base=grafip[n];
	for (x=0;x<769;x++){  pal[x]=*base; base++;}
	paletapal();
}
/* ---BORRA PANTALLA ---- */
void clear(unsigned char c)
{
unsigned int x;
pv=pvx;
for(x=0;x<64000;x++,pv++)*pv=c;
}
/* ----IMPRIME CADENA ---*/
void printc(int x,int y,char *texto)
{
unsigned char z;
	for(z=0;z<40 && texto[z]!=0;z++){ impri(x,y,texto[z]); x+=8*FONTX;}
}
/* ---- IMPRIME NUMERO ----*/
void printn(int x,int y,long num)
{
int z;
 for(z=0;z<40;z++)VARI[z]=0;
 sprintf(VARI,"%lu",num);
 printc(x,y,VARI);
}

/*---- IMPRIME CARACTER ----*/
void impri (int x,int y,unsigned char ca)
{

unsigned short d,d1,z,zz,z2,zz2;
unsigned char n,c;
/*    if(x<0 || y<0 || x>320 || y>200) goto fin; */
     z=320*y+x;
     pv=pvx+z;
     zz=ca*8;
     if(FONTX==1 && FONTY==1)
      {
	for(z=zz;z<zz+8;z++)
	 {
	  n=tabla[z];
	  for (c=0;c<8;c++)
		{
		if(n&128) *pv=INK; else *pv=PAPER;
		pv++; n=n<<1;
		}
	 pv+=312;
         }
      }
      else
      {
       x=320-(FONTX*8);
       for(z=zz;z<zz+8;z++)
	 {
	  for(zz2=FONTY;zz2>0;zz2--)
	   {
            n=tabla[z];
	    for (c=0;c<8;c++)
	     {
	      for(z2=FONTX;z2>0;z2--)
		 {
		  if(n&128) *pv=INK; else *pv=PAPER;
		  pv++;
		 }
	      n=n<<1;
             }
             pv+=x;
           }
	 }
      }
fin:
}

/* ---- CARGA FONTS -------*/

void loadfont(char nombre[12])
{
 int x;
 if((pf=fopen(nombre,"rb"))==NULL)
	 {
	  /* pv=0xFFA6000E; */
	  for(x=0;x<2040;x++){tabla[x]=*pv; pv++;}
	 }
	else
	 {
	  x=fread(VARI,1,1,pf);
	  if(VARI[0]=='S')
			{
			 x=fread(VARI+1,9,1,pf);
			 x=fread(tabla,2040,1,pf);
			}
		else
			{
			 tabla[0]=VARI[0];
			 x=fread(tabla+1,2040,1,pf);
			}
	  fclose(pf);
	 }
}


void plot(int x,int y)
{
 if(x<320 && x>=0 && y<200 && y>=0)
	{
	pv=pvx+320*y+x;
	*pv=INK;
	}
}

int point(int x,int y)
{
 if(x<320 && x>=0 && y<200 && y>=0)
	{
	pv=pvx+320*y+x;
	return(*pv);
	}
  else {
	 return(255);
	}
}

/* ---LINEA --------------*/

void line(int x,int y,int xx,int yy)

{

 long int d;

 unsigned int z,zz,c,a,vx,vy;



 if(x==xx)

	{

	 if(y>yy){z=y;y=yy;yy=z;}

	 if(y<0) y=0;

	 if(yy>199)yy=199;

	 pv=pvx+320*y+x;

	 for(;y<=yy;y++){*pv=INK;pv+=320;}

	 goto fin;

	}

 if(y==yy)

	{

	 if(x>xx){z=x;x=xx;xx=z;}

	 if(x<0)x=0;

	 if(xx>319)x=319;

	 pv=pvx+320*y+x;

	 for(;x<=xx;x++){*pv=INK;pv++;}

	 goto fin;

	}

 if(x<xx)

	if(y<yy)

		 goto normal;

	   else

		 goto nonormal;

 if(x>xx)

	if(y>yy)

		{

		 z=xx;xx=x;x=z;z=yy;yy=y;y=z; goto normal;

		}

	   else

		{

		 z=xx;xx=x;x=z;z=yy;yy=y;y=z; goto nonormal;

		}

nonormal:

	 vx=xx-x; vy=y-yy;a=0;

	 plot(x,y); plot(xx,yy);

	 if(vx>vy)

		{

		 c=vx;

		 while(c>0)

			{

			 c--;x++;a+=vy;

			 if(a>vx){a-=vx; y--;}

			 plot(x,y);

			}

		}

	   else

		{

		 c=vy;

		 while(c>0)

			{

			 c--;y--;a+=vx;

			 if(a>vy){a-=vy;x++;}

			 plot(x,y);

			}

		}

 goto fin;

normal:

	 vx=xx-x;vy=yy-y;a=0;

	 plot(x,y); plot(xx,yy);

	 if(vx>vy)

		{

		 c=vx;

		 while(c>0)

			{

			 c--; x++; a=a+vy;

			 if(a>vx){ a-=vx; y++; }

			 plot(x,y);

			}

		}

		else

		{

		 c=vy;

		 while(c>0)

			{

			 c--; y++; a=a+vx;

			 if(a>vy){ a-=vy; x++; }

			 plot(x,y);

			}

		}

fin:

;

}
void box(int x,int y,int xx,int yy)
{
	line(x,y,xx,y);
	line(xx,y,xx,yy);
	line(xx,yy,x,yy);
	line(x,yy,x,y);
}
/* ------ Tratamiento de errores ----- */
void error(int z)
{
	switch(z)
		{
		 case 2:
			printc(0,0,"Fichero no encontrado");
			break;
		 case 8:
			printc(0,0,"Memoria insuficiente");
			break;
		 case 13:
			printc(0,0,"Dato invalido");
			break;
		 default:
			printc(0,0,"Error desconocido");
			break;
		}
}

/* ---- LEE CADENA DEL TECLADO ----*/
void inputc(int x,int y,char *nombre)
{
int z,zz,n;
	printc(x,y,nombre);
	pv=nombre;
	for(z=0;z<40;z++){ if(*pv==0)break;  pv++;} 
	x=x+(z<<3); z=x; n=0; zz=0;
	while(zz!=10)
		{
		 zz=inkey();
		 if(zz==13 || zz==27) goto fin;
		 if(zz!=0)
			{
			 if(zz==8)
			  { if(n!=0){z-=8;n--;impri(z,y,32);} }
			  else
			  { impri(z,y,zz); if(n<38){z+=8; VARI[n]=zz; n++;}}
			}
		}
fin:
	VARI[n]=0;
}

/* ---- LEE NUMERO DEL TECLADO ----*/
long inputn(int x,int y,char *nombre)
{
	inputc(x,y,nombre);
	return(atol(VARI));
}


void bar(int x,int y,int xx,int yy)
{
 int c,cc;

 if(x<320 && x>=0 && y<200 && y>=0 && xx<320 && xx>=0 && yy<200 && yy>=0)
 for(c=y;c<=yy;c++)
		{
		pv=pvx+320*c+x;
		for(cc=x;cc<=xx;cc++)
				{
				*pv=INK;
				pv++;
				}
		}
}
