//TETRIS SDL__________________________________________
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <time.h>
#include <sys/time.h>

#include <SDL/SDL.h>
#include "SDL/SDL_ttf.h"
#include "SDL/SDL_image.h"
#include "SDL/SDL_mixer.h"

#include "main.h"
#include "xgrafi.h"



#define ANCHO 14
#define ALTO 23
#define PIEZA 48
#define NOPIEZA 32
#define PARED 35
#define RX 12
#define RY 0


void ipieza(int x,int y,char pi,char po,char c);
void ppieza(int x,int y ,char pi,char po,char c);
char gpieza(int x,int y ,char pi,char po);
void repintar(void);
void inicializar(void);
void avance();
void npieza();
void blinea();

int z,zz;
int t,pi,po,x,y,xx,yy,yy1,poo;
char cu[ANCHO+4][ALTO+4];
unsigned int velo,velo1,pu,maxpu;


char fi[168]={1,0,0,1,1,1, 1,0,0,1,1,1, 1,0,0,1,1,1, 1,0,0,1,1,1,
              -1,0,1,0,2,0, 0,-2,0,-1,0,1, -1,0,1,0,2,0, 0,-2,0,-1,0,1,
              -1,0,0,1,1,1, 0,-1,-1,0,-1,1, -1,0,0,1,1,1, 0,-1,-1,0,-1,1,
              1,0,-1,1,0,1, 0,-1,1,0,1,1, 1,0,-1,1,0,1, 0,-1,1,0,1,1,
			  0,-1,-1,0,1,0, 0,-1,-1,0,0,1, -1,0,1,0,0,1, 0,-1,1,0,0,1,
              -1,-1,-1,0,1,0, 0,-1,-1,1,0,1, -1,0,1,0,1,1, 0,-1,1,-1,0,1,
              1,-1,-1,0,1,0, -1,-1,0,-1,0,1, -1,0,1,0,-1,1, 0,-1,0,1,1,1};
  
unsigned int  ti,ti1=2;
char VARI[160];  
  


//====================JUEGO=======================

int main (int argc, char *argv[])
{
  int quit = 0;
  int SimbolKey;
  
  if (init(640, 480) == 0 ) return 1;

  SDL_FillRect( screen, NULL, SDL_MapRGB( screen->format, 0x42, 0x73, 0x4A ) );
  if ( SDL_Flip( screen ) == -1 ) return 3;
  if (load_files((char*)"modelo2.png", (char*)"modelo1.png", (char*)"setam.ttf") == 0 ) return 2;
  
  
  load_puntos();
  //puntuar(0);
  
  
 //__________JUEGO______________
INICIO:

		srand(time(NULL));	
		inicializar();
		npieza();
		velo=velo1=50; ti1=0; pu=0;


  while ( quit == 0 )
  {
    SDL_Delay(20);
    avance();
    
    if(y==0 && yy1!=300) {puntuar(pu); goto INICIO;}
    if(xx!=x || y!=yy || po!=poo)
			{ 
			  ppieza(xx,yy,pi,poo,NOPIEZA);
			  if(1==gpieza(x,y,pi,po)){y=yy;x=xx;po=poo;}
			  ppieza(x,y,pi,po,PIEZA);
			}
	xx=x; yy=y; poo=po;
      
    while ( SDL_PollEvent( &event ) )
    {

      switch (event.type)
      {
        case  SDL_KEYUP:
          SimbolKey = event.key.keysym.sym;
          break;
        case  SDL_KEYDOWN:
          SimbolKey = event.key.keysym.sym;

          switch (SimbolKey)
          {
			case  SDLK_q:
			  quit = 1;
			  break;
			case  SDLK_7:
			  x--;
			  break;
			case  SDLK_8:
			  po++; if(po>4)po=1;
			  break;
			case  SDLK_9:
			  x++;
			  break;
			case  SDLK_SPACE:
			  velo1=5;
			  break;	
			case  SDLK_0:
			  Repaint();
			  break;		
			
            case  SDLK_F1:
#if YesWindows
              screen = SDL_SetVideoMode( SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP, SDL_FULLSCREEN | SDL_SWSURFACE );
#else
              SDL_WM_ToggleFullScreen(screen);
#endif
              Repaint();
              break;
            case  SDLK_F2:
              screen = SDL_SetVideoMode( SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP, SDL_SWSURFACE );
              Repaint();
              break;
          }

          break;
        
        case  SDL_QUIT:
          quit = 1;
          break;
      }
    }

  }


#ifdef DEBUG
  printf("Fin\n");
#endif
	screen = SDL_SetVideoMode( SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP, SDL_SWSURFACE );
  SDL_Delay(100);
  return 0;
}

//______________________________FIN______________________

void impriBloque16(int x, int y, int n)
{
  switch (n)
  {
	case 0:
      imprixxx(0, 16, x, y, 16, 16);
      break;
    case 1:
      imprixxx(0, 0, x, y, 16, 16);
      break;
    default:
      imprixxx(0, 0, x, y, 16, 16);
      break;
  }
}



void imprixxx(int xi, int yi, int xo, int yo, int w, int h)
{
  static SDL_Rect clip[ 1 ];
  clip[ 0 ].x = xi;
  clip[ 0 ].y = yi;
  clip[ 0 ].w = w;
  clip[ 0 ].h = h;
  apply_surfaceB( xo, yo, dots, screen, &clip[ 0 ] );
}



//=====================================00


/* ---- devuelve tiempo del sistema ---- */
unsigned int Ctime(void)
{
 struct timeval tv;
 unsigned int z,zz;
	gettimeofday(&tv,NULL);
	z=tv.tv_usec/10000;
	zz=(tv.tv_sec & 0x00fff)*100;
	return(zz+z);
}


void ipieza(int x,int y,char pi,char po,char c)
{
	unsigned int z;

		pi--; po--;
		z=pi*24+po*6;
		 impriBloque16(x<<4,y<<4,c);
		 impriBloque16((x+fi[z])<<4,(y+fi[z+1])<<4,c);
		 impriBloque16((x+fi[z+2])<<4,(y+fi[z+3])<<4,c);
		 impriBloque16((x+fi[z+4])<<4,(y+fi[z+5])<<4,c);
		 SDL_Flip(screen);
}

 
void blinea()
{
 int z,zz,i;
	for(zz=2;zz<ALTO+2;zz++)
		{
		 i=0;
		 for(z=3;z<ANCHO+1;z++)  if(cu[z][zz]==NOPIEZA)i=1;
		 if(i==0)
			{
			 for(i=zz;i>1;i--) for(z=3;z<ANCHO+1;z++) cu[z][i]=cu[z][i-1];
			 pu+=100; repintar();
			}
		}
}

void npieza()
{
		xx=x=ANCHO/2-1; yy=y=0; yy1=300;
		poo=po=1+rand()%4; pi=1+rand()%7;

}

void avance()
{
	ti=Ctime();
	
	if( ti>ti1 || ti+1000<ti1 )	
		{
		 ti1=Ctime() + velo1;

		 if(yy1==y)
		  {
		  ppieza(x,y,pi,po,NOPIEZA);
		  if(1==gpieza(x,y+1,pi,po))
			{
             ppieza(x,y,pi,po,PIEZA);
			 npieza(); pu+=10; locate(30,7); printf("%d\n",pu);
			 blinea();
			 velo1=velo;
			 if(pu>3000) velo=velo1=30;
			}
           ppieza(x,y,pi,po,PIEZA);
		  }
		  yy1=y;
		 y++;
	}
}

char gpieza(int x,int y ,char pi,char po)
{
char c;
int z;
        pi--; po--;
        z=pi*24+po*6;
		c=0;
		if(cu[x+2][y+2]!=NOPIEZA)c=1;
		if(cu[2+x+fi[z]][2+y+fi[z+1]]!=NOPIEZA)	c=1;
		if(cu[2+x+fi[z+2]][2+y+fi[z+3]]!=NOPIEZA) c=1;
		if(cu[2+x+fi[z+4]][2+y+fi[z+5]]!=NOPIEZA) c=1;
		return(c);
}

void inicializar(void)
{
		for(x=0;x<ANCHO+4;x++)for(y=0;y<ALTO+4;y++)cu[x][y]=NOPIEZA;
		for(y=0;y<ALTO;y++)
			{
			 cu[2][y+2]=PARED; cu[ANCHO+1][y+2]=PARED;
			}
		for(x=0;x<ANCHO;x++)
			{
			 cu[x+2][ALTO+2]=PARED;
			}

}

/* pi=pieza(1 a 5)  po=posicion(1 a 4) */
void ppieza(int x,int y,char pi,char po,char c)
{
 int z;
        pi--; po--;
        z=pi*24+po*6;
                        
		locate(RX+x,y); printf("%c",c);
		locate(RX+x+fi[z],y+fi[z+1]);printf("%c",c);
		locate(RX+x+fi[z+2],y+fi[z+3]);printf("%c",c);
		locate(RX+x+fi[z+4],y+fi[z+5]);printf("%c",c);
		
		
		
        cu[x+2][y+2]=c;
        cu[2+x+fi[z]][2+y+fi[z+1]]=c;
        cu[2+x+fi[z+2]][2+y+fi[z+3]]=c;
		cu[2+x+fi[z+4]][2+y+fi[z+5]]=c;
		printf("\n ");
}

void repintar(void)
{
 int z,zz,x,y;
 char c;
 
  SDL_WM_SetCaption( "COCINERO_sdl", NULL );

  SDL_FillRect(screen, 0, SDL_MapRGB(screen->format, 0, 0, 0));
		for(zz=0;zz<ALTO;zz++)
			{
			  for(z=1;z<ANCHO-1;z++)
			  {
			   c=cu[z+2][zz+2];
			   if(c==NOPIEZA)
				{
				impriBloque16((z+RX)<<4,(zz+RY)<<4,NOPIEZA);
				}
				else
				{
				 impriBloque16((z+RX)<<4,(zz+RY)<<4,PIEZA);
				}
			  }
			}
									
	for(y=0;y<ALTO;y++)
			{
			 impriBloque16(RX<<4,y<<4,PARED);
			 impriBloque16((RX+ANCHO-1)<<4,y<<4,PARED);
			}

	for(x=0;x<ANCHO;x++) { impriBloque16((RX+x)<<4,ALTO<<4,PARED); }
	//ipieza(32,10,pin,3,PIEZA);
	//printn(0,0,pu);
			
	SDL_Flip(screen);
}            








//=====================
void Repaint(void)
{
  SDL_WM_SetCaption( "COCINERO_sdl", NULL );
  //apply_surface( 0, 0, background, screen );
  SDL_FillRect(screen, 0, SDL_MapRGB(screen->format, 0, 0, 0));
  repintar();
  SDL_Flip( screen );
}



//______PUNTOS___________

int load_puntos(void)
{
 FILE *pf;
 int z;
 
  if ((pf = fopen("maxi.pun", "rb")) == NULL)
  {
    printf("ERROR en maxi.pun/n");
    return (2);
  }
  else
  {
    z = fread(puntosMax, 20, 1, pf);
    z += fread(nombresMax, 48, 1, pf); 
    fclose(pf);
  }
 return(0);
}

void puntuar(long pun)
{
  int x, xx, z, c, cc;
  char temporal[20];
  FILE *pf;
  
  setcolor(0, 0, 0);
  bar(0, 0, 800, 600);

  if (pun > puntosMax[4] )
  {
    puntosMax[4] = pun;
    setcolor(0, 0, 0);        bar(0, 0, 800, 600);
    setcolor(255, 255, 0);    printc(100, 80, (char*)"RECORD ESCRIBE TU NOMBRE");
    SDL_Flip( screen );
    sprintf(temporal, "%s", inputc(140, 120));
    for (c = 0; c < 8; c++) nombresMax[c][4] = 0;
    for (c = 0; c < 8 && temporal[c] != 0 ; c++) nombresMax[c][4] = temporal[c];
    nombresMax[7][4] = 0;
    for (xx = 4; xx > 0; xx--)
    {
      x = xx - 1;
      if (puntosMax[x] < puntosMax[x + 1])
      {
        puntosMax[5] = puntosMax[x];
        puntosMax[x] = puntosMax[x + 1];
        puntosMax[x + 1] = puntosMax[5];
        for (z = 0; z < 8; z++)
        {
          nombresMax[z][5] = nombresMax[z][x];
          nombresMax[z][x] = nombresMax[z][x + 1];
          nombresMax[z][x + 1] = nombresMax[z][5];
        }
      }
    }
    if ((pf = fopen("maxi.pun", "wb")) == NULL)
    {
      printf("Error archivo MAX.PUN");
    }
    else
    {
      z = fwrite(puntosMax, 20, 1, pf);
      z = fwrite(nombresMax, 48, 1, pf);
    }
    fclose(pf);

  }
  setcolor(0, 0, 0);
  bar(0, 0, 640, 480);
  setcolor(255, 0, 0);
  printc(200, 80, (char*)"MAXIMAS PUNTUACIONES");
  printc(200, 96, (char*)"--------------------");
  setcolor(255, 255, 0);
  SDL_Flip( screen );
  z = 2;
  for (x = 0; x < 5; x++)
  {
    z++;
    for (cc = 0; cc < 8; cc++)
    {
      impri((cc * 16 + 210), (x * 16 + 160), nombresMax[cc][x]);
    }
    printn((cc * 16 + 210), (x * 16 + 160), puntosMax[x]);
  }

  SDL_Flip( screen );
  SDL_Delay(2000);
}




//___________Rutinas basicas___________________
int inkeyM()
{
  int tecla;
  SDL_Delay(200);
  while ( SDL_PollEvent( &event ) )
  {
    switch (event.type)
    {
      case  SDL_KEYUP:
        tecla = event.key.keysym.sym;
        //            printf("Evento Tecla UP  %d \n",tecla);
        if (tecla > 96 && tecla < 123) tecla -= 32;
        return (tecla);
        break;
      case  SDL_QUIT:
        return (27);
        break;
    }
  }
  return (0);
}


//__________________________________

void printc(int x, int y, char* temp)
{
  SDL_Surface *message;
  message = TTF_RenderText_Solid( font, temp, ColorDefault );
  apply_surface( x, y, message, screen );
  SDL_FreeSurface(message); 
}

void printn(int x, int y, long temp)
{
  char VARI[20];
  sprintf(VARI, "%d", (int)temp);
  printc(x, y, VARI);
}

void impri(int x, int y, char c)
{
  char VARI[20];
  sprintf(VARI, "%c", c);
  printc(x, y, VARI);
}



/* ---- LEE CADENA DEL TECLADO ----*/

char *inputc(int x, int y)
{

  int zz, n;
  static char VARI[10];

  //  setcolor(0,100,0);
  //  bar(x,y,x+100,y+20);
  //  SDL_Flip( screen );
  n = 0; zz = 0;
  while (zz != 10)
  {
    zz = inkeyM();
    if (zz == 13 || zz == 27) goto fin;
    if (zz != 0)
    {
      setcolor(0, 100, 0);
      bar(x, y, x + 100, y + 20);
      setcolor(255, 255, 255);
      if (zz == 8)
      {
        n--;
        if (n < 0)n = 0;
        VARI[n] = 0;
      }
      else
      {
        VARI[n] = zz; VARI[n + 1] = 0;
        if (n < 6)n++;
      }
      printc(x, y, VARI);
      //        printf("%s\n",VARI);
      SDL_Flip( screen );
    }
  }
fin:
  VARI[n] = 0;
  return (VARI);
}

