/* ---- (c) SETA DOMINIO PUBLICO ---- */
/* ---- COPILADOR TC  ---------- */
/* ---- MODIFICADO EL 10-03-1998 ----- */
/* ---- RUTINAS PARA EL MODO 320x200 256 COLORES MODO 0x13 ---- */

#include "stdio.h"
#include "dos.h"
#include "bios.h"
#include "stdlib.h"
#include "alloc.h"
#include "time.h"



/* ---- RUTINAS CON BAJO NIVEL ---- */
void locate(int x,int y);
void cls();
int dmode(void);
void mode(int mode_code);
void clear(unsigned char c);
void plot(int x,int y);
int point(int x,int y);
void line(int x,int y,int xx,int yy);
void bar(int x,int y,int xx,int yy);
void impri (int x,int y,unsigned char ca);
void loadfont(char *nombre);
void loadpcx(char *nombre);
int bioskey(int cmd);
void mouse(int x);
void mouses(int x,int y,int t);
void paleta();
void paletapal();
void velocidad(void);
void espera(unsigned int c);
unsigned int Ctime(void);
void sonido(unsigned int frecuencia,unsigned int duracion);
void Sbeep(unsigned int high);
void getblock(int n,int x,int y,unsigned int ancho,unsigned int alto);
void putblock(int n,int x,int y);
void loadblock(int n,char *nombre);
void putz(int n,long xd,long yd,long xs,long ys, long xx, long yy);
void getz(int n,long xd,long yd,long xs,long ys, long xx, long yy);
void fade(int num);
/* -------------------------------- */
/* ---- RUTINAS NORMALES ----- */
void inputc(int x,int y,unsigned char nombre[40]);
long inputn(int x,int y,unsigned char nombre[40]);
void box(int x,int y,int xx,int yy);
unsigned int inkey2(void);
int inkey(void);
void mks( long num);
void printc(int x,int y,char *texto);
void printn(int x,int y,long num);
void error(int z);
void waits(unsigned int x);
/* --------------------------- */


char VARI[39];
unsigned char far *pvx=(char far *)0xA0000000;
unsigned char far *pvm=(char far *)0xA000fa00;
unsigned char far *pv,*pv1;
int INK,PAPER,SPEED,SETIM;
int XMOUSE,YMOUSE,KMOUSE,CMOUSE,MX,MY,MK,MOUSE,IMOUSE,PMOUSE;
int FONTX=1,FONTY=1,CX,CY;
FILE *pf;
unsigned char tabla[2040],pal[800];
unsigned char tleta[35]= {0,0,0,0,0,63,63,0,0,36,0,36,0,63,0,32,63,63,63,63,0,63,63,63,0,0,0 };
unsigned char tmouse[64]= {0,0,0,0,0,0,3,3,
			0,1,1,1,1,0,3,3,
			0,1,1,1,0,3,3,3,
			0,1,1,1,0,3,3,3,
			0,1,0,0,1,0,3,3,
			0,0,3,3,0,1,0,3,
			3,3,3,3,3,0,1,0,
			3,3,3,3,3,3,0,0};
unsigned char xmouse[64];
unsigned char *grafi[16];

/* ---- <1 aclara-- >1 oscurece ---- */
void fade(int num)
{
int z,zz,x,nu,f1;
int pal1[769];
  f1=Ctime();
  if(num>0)
   {
	for(x=0;x<769;x++) pal1[x]=pal[x];
	nu=70-num*13;
	for(z=0;z<nu;z++)
	   {
		for(zz=0;zz<769;zz++) if(pal1[zz]>num)pal1[zz]-=num;
		outportb(0x3c8,0);
		for(x=0;x<769;x++) outportb(0x3c9,pal1[x]);
		while(f1==Ctime());
		f1=Ctime();
	   }
	 for(x=0;x<769;x++) pal1[x]=0;
	 outportb(0x3c8,0);
	 for(x=0;x<769;x++) outportb(0x3c9,pal1[x]);
	}
	else
	{
	num=num*-1;
	for(z=70;z>10;z-=num)
	   {
		for(zz=0;zz<769;zz++) pal1[zz]=pal[zz]-z;
		outportb(0x3c8,0);
		for(x=0;x<769;x++)
			if(pal1[x]>0){outportb(0x3c9,pal1[x]);} else {outportb(0x3c9,0);}
		while(f1==Ctime());
		f1=Ctime();
	   }
	 for(x=0;x<769;x++) pal1[x]=pal[x];
	 outportb(0x3c8,0);
	 for(x=0;x<769;x++) outportb(0x3c9,pal1[x]);
	}
}

void Sbeep(unsigned int high)
{
unsigned char p,cl,ch;
	cl=high & 0x00FF;
	ch=(high>>8) & 0x00FF;
	p = inportb(0x61);
	if(high)
		{
		 outportb(0x61, p|3);
		 outportb(0x43,0xb6);
		 outportb(0x42,cl);
		 outportb(0x42,ch);
		}
	 else
		{
		 outportb(0x61,p&0xfc);
		}
}
/* --- Devuelve contador interno de tiempos 18 por segundo --- */
unsigned int Ctime(void)
{
unsigned int c;
union REGS r;
	r.h.ah=0;
	int86(0x1A,&r,&r);
	c=r.x.dx;
	return(c);
}

/* ---- CARGA FONTS -------*/
void loadfont(char nombre[12])
{
 int x;
 if((pf=fopen(nombre,"rb"))==NULL)
	 {
	  pv=(char far *)0xFFA6000E;
	  for(x=0;x<2040;x++){tabla[x]=*pv; pv++;}

	 }
	else
	 {
	  x=fread(VARI,1,1,pf);
	  if(VARI[0]=='S')
			{
			 x=fread(VARI+1,9,1,pf);
			 x=fread(tabla,2040,1,pf);
			}
		else
			{
			 tabla[0]=VARI[0];
			 x=fread(tabla+1,2040,1,pf);
			}
	  fclose(pf);
	 }

}


/* ----    LEE TECLA   ---*/
int inkey(void)
{
 int t;
 do
  { if(bioskey(1)!=0){t=bioskey(0);}
					 else
					 {t=0;}
   }
 while(bioskey(1)!=0);
 return(t&255);
 }
/*---- IMPRIME CARACTER ----*/
void impri (int x,int y,unsigned char ca)

{

int z,zz;
unsigned char n,c;

pv=pvx+x+y*320;
zz=ca*8;
for(z=zz;z<zz+8;z++)
 {
n=tabla[z];
 for (c=0;c<8;c++)
	{
		if(n&128)
		 { *pv=INK;}
		 else
		 {*pv=PAPER;}
		pv++;
		n=n<<1;
	}
 pv+=312;
 }
}

/* ---- TRANSFORMA NUMERO A CADENA ----*/
void mks( long num)
{
 int z;
 for(z=0;z<40;z++)VARI[z]=0;
 sprintf(VARI,"%lu",num);
}
/* ----IMPRIME CADENA ---*/
void printc(int x,int y,char *texto)
{
unsigned char z;
 for(z=0;z<40 && texto[z]!=0;z++){
		impri(x,y,texto[z]);
		x+=8*FONTX;
		}
}
/* ---- IMPRIME NUMERO ----*/
void printn(int x,int y,long num)
{
 mks(num);
 printc(x,y,VARI);
}
/* ---BORRA PANTALLA ---- */
void clear(unsigned char c)
{
unsigned int x;
pv=pvx;
for(x=0;x<64000;x++,pv++)*pv=c;
}

/* modo de pantalla */
void mode(int mode_code)
{
union REGS r;
r.h.al=mode_code;
r.h.ah=0;
int86(0x10,&r,&r);
}
/* colocar cursor en un lugar determinado */
void locate(int x,int y)
{
union REGS r;
r.h.ah=2;
r.h.dl=x;
r.h.dh=y;
r.h.bh=0;
int86(0x10,&r,&r);
}
/*borra pantalla*/
void cls()
{
union REGS r;
r.h.ah=6;
r.h.al=0;
r.h.ch=0;
r.h.cl=0;
r.h.dh=24;
r.h.dl=79;
r.h.bh=7;
int86(0x10,&r,&r);
}
/* da modo de pantalla */
int dmode(void)
{
union REGS r;
r.h.al=0;
r.h.ah=0x0F;
int86(0x10,&r,&r);
return(r.h.al);
}

void loadpcx(char nombre[12])
{

unsigned int x,z,lon;
unsigned char a,b,verde,azul,rojo;
union REGS r;

if ((pf=fopen(nombre,"rb"))==NULL) goto fin;
	for (x=0;x<769;x++) pal[x]=0;
	  r.h.ah=0x10;
	  r.h.al=0x12;
	  r.x.bx=0;
	  r.x.cx=0x0100;
	  r.x.dx=FP_OFF(pal);
	  int86(0x10,&r,&r);
z=0;
pv=pvx;
for(x=0;x<128;x++)a=getc(pf);
for(x=0;x<63999;x++)
	{
	a=getc(pf);
	if(a>192){
		 b=a-192;
		 a=getc(pf);
		 }
		 else
		 {
		 b=1;
		 }
	while(b!=0){
		   b--;
		   *pv=a;
		   pv++;
		   z++;
		   if(z>63999)goto salto;
		   }
	}

salto:
a=getc(pf);
for (x=0;x<769;x++) pal[x]=(getc(pf))/4;
	  r.h.ah=0x10;
	  r.h.al=0x12;
	  r.x.bx=0;
	  r.x.cx=0x0100;
	  r.x.dx=FP_OFF(pal);
	  _ES=FP_SEG(pal);
	  int86(0x10,&r,&r);
fclose(pf);
fin:
a=a;
}
/*---- coloca paleta por defecto ----*/
void paleta()
{
union REGS r;
r.h.ah=0x10;
r.h.al=0x12;
r.x.bx=0;
r.x.cx=0x000A;
r.x.dx=FP_OFF(tleta);
_ES=FP_SEG(tleta);
int86(0x10,&r,&r);
}
/* ---- coloca la paleta situada en la variable pal ---- */
void paletapal()
{
int x;
	outportb(0x3c8,0);
	for(x=0;x<769;x++) outportb(0x3c9,pal[x]);
}
/*---- devuelve la velocidad del ordenador ----*/
void velocidad(void)
{
unsigned int c,cc,z;
union REGS r;
	z=0;
	r.h.ah=0; int86(0x1A,&r,&r); c=r.x.dx;
	cc=c;
	while(cc==c){ r.h.ah=0; int86(0x1A,&r,&r); cc=r.x.dx;}
	c=cc;
	while(cc==c){z++; r.h.ah=0; int86(0x1A,&r,&r); cc=r.x.dx;}
	SPEED=z/15;
}
/*--- espera un tiempo  calculado 18 cada segundo---*/
void espera(unsigned int c)
{
unsigned int cc;
union REGS r;
r.h.ah=0;
int86(0x1A,&r,&r);
cc=r.x.dx;
cc+=c;
c=0;
while(c<cc){r.h.ah=0;int86(0x1A,&r,&r);c=r.x.dx;}
}
/* --- produce un sonido --*/
void sonido(unsigned int frecuencia,unsigned int duracion)
{
	unsigned char c;
	unsigned int x;
	frecuencia=frecuencia*SPEED;
	disable();
	c=inportb(0x61);
	c=c&0xFE;
while(duracion>1)
	{
	c=c|0x02;
	outportb(0x61,c);
	x=frecuencia;
	while(x>1)x--;
	c=c&0xFD;
	outportb(0x61,c);
	x=frecuencia;
	while(x>1)x--;
	duracion--;
	}
enable();
}

void vscroll(int y)
{
	unsigned int c;
    if(y>0){
	pv=pvx;
	c=y*320;
	pv1=pv+c;
	   while(c<64000){
			*pv=*pv1;
			pv++;
			pv1++;
			c++;
			}
	    }
     else
	    {
	y=y*-1;
	c=y*320;
	pv=pvm;
	pv1=pv-c;
	while(c<64000){
			*pv=*pv1;
			pv--;
			pv1--;
			c++;
			}

	    }
}

void hscroll(int x)
{
	unsigned int c,cc;
    if(x>0){
		 for(cc=1;cc<201;cc++)
			{
			pv=pvx+(320*cc)-1;
			pv1=pv-x;
			   for(c=x;c<320;c++){
					*pv=*pv1;
					pv--;
					pv1--;
					}
			}
	    }
     else
	    {
	      x=x*-1;
	      for(cc=0;cc<200;cc++)
			{
			pv=pvx+(320*cc);
			pv1=pv+x;
			   for(c=x;c<319;c++){
					*pv=*pv1;
					pv++;
					pv1++;
					}
			}
	    }
}

/* ---- LEE BLOQUE ---- */
void loadblock(int n,char *nombre)
{
unsigned int x,xx,z,zz,cx,cy;
unsigned char a,b;
long  d1,d2,dd,me;
unsigned char  *base;

	if ((pf=fopen(nombre,"rb"))==NULL) {error(2); goto fin;}
	x=fread(pal,128,1,pf);
	d1=1+pal[9]*256+pal[8];
	d2=1+pal[11]*256+pal[10];
	if(d1<320)d1+=1;
	me=d1*d2+4;
	if(grafi[n]!=0) farfree(grafi[n]);
	grafi[n]=farmalloc(me);
	if(grafi[n]==0){error(8); goto fin;}
	me-=4;
	base=grafi[n];
	*base=d1&0x00FF;
	base++;
	*base=(d1>>8)&0x00FF;
	base++;
	*base=d2&0x00FF;
	base++;
	*base=(d2>>8)&0x00FF;
	base++;
while(1<2)
	{
	a=getc(pf);
	if(a>192){ b=a-192; a=getc(pf);} else {b=1;}
	while(b!=0){
		   b--;
		   *base=a;
		   base++;
		   me--;
		   if(me<0)goto salto;
		   }
	}
salto:
	for(x=0;x<3;x++)a=getc(pf);
	x=fseek(pf,-768L,2);
	x=fread(pal,769,1,pf);
	for (x=0;x<769;x++) pal[x]=pal[x]/4;
	fclose(pf);
fin:
;
}
void getblock(int n,int x,int y,unsigned int ancho,unsigned int alto)
{
	unsigned int c,cc;
	unsigned char *base;
	c=ancho*alto+4;
	if(grafi[n]!=0) free(grafi[n]);
	grafi[n]=malloc(c);
	if(grafi[n]==0){printc(0,0,"sin memoria"); goto getfin;}
	base=grafi[n];
	*base=ancho&0x00FF;
	base++;
	*base=(ancho>>8)&0x00FF;
	base++;
	*base=alto&0x00FF;
	base++;
	*base=(alto>>8)&0x00FF;
	base++;
	c=y*320+x;
	pv=pvx+c;
	for(cc=0;cc<alto;cc++)
		{
		for(c=0;c<ancho;c++)
			{
			 *base=*pv;
			 base++;
			 pv++;
			}
		pv=pv-ancho+320;
		if(pv>pvm)pv=pvm;
		}
 getfin:
 ;
}

void putblock(int n,int x,int y)
{
unsigned int c,cc,z,ancho,alto;
unsigned char *base;
	base=grafi[n];
	if(base==0) goto putfin;
	ancho=*base;
	base++;
	z=*base; ancho+=(z<<8);
	base++;
	alto=*base;
	base++;
	z=*base; alto+=(z<<8);
	base++;
	c=y*320+x;
	pv=pvx+c;
	for(cc=0;cc<alto;cc++)
		{
		for(c=0;c<ancho;c++)
			{
			if(x+c<=320) *pv=*base;
			 base++; pv++;
			 if(pv>pvm)pv=pvm;
			}
		pv=pv-ancho+320;
		if(pv>pvm)pv=pvm;
		}
 putfin:
 ;
}
/*  ------------------------------------------------
	Guarda una zona de la pantalla en la zona (n)
	xd,yd  cordendas de origen pantalla
	xs,ys  cordenadas de destino zona
	xx,yy  tamao de la zona
*/
void getz(int n,long xd,long yd,long xs,long ys, long xx, long yy)
{
	long  d,d2;
	unsigned int c,cc,z,zz,x1,y1;
	unsigned char huge *base;
	long ancho,alto;
	base=grafi[n];
	if(base==0) goto getfin;
	ancho=*base;
	base++;
	z=*base; ancho+=(z<<8);
	base++;
	alto=*base;
	base++;
	z=*base; alto+=(z<<8);
	base++;
	if(xs+xx>ancho || ys+yy>alto) goto getfin;
	d2=xs+(ancho*ys);  base+=d2;

	x1=xd+xx; y1=yd+yy;
	zz=ancho-xx;
	z=yd;
	for(cc=yd;cc<y1;cc++)
		{
        pv=pvx+z*320+xd;
		for(c=xd;c<x1;c++)
			{
			 *base=*pv;
			 base++; pv++;
			}
		base+=zz;
		z++;
		}
 getfin:
 ;
}

/*  ------------------------------------------------
	imprime una una parte de la zona (n) en pantalla
	xd,yd  cordendas de destino
	xs,ys  cordenadas de fuente
	xx,yy  tamao de la zona
*/
void putz(int n,long xd,long yd,long xs,long ys, long xx, long yy)
{
	long  d,d2;
	unsigned int c,cc,z,zz,x1,y1;
	unsigned char  *base;
	long ancho,alto;
	base=grafi[n];
	if(base==0) goto putfin;
	ancho=*base;
	base++;
	z=*base; ancho+=(z<<8);
	base++;
	alto=*base;
	base++;
	z=*base; alto+=(z<<8);
	base++;
	d2=xs+(ancho*ys);  base+=d2;
	x1=xd+xx; y1=yd+yy;
	zz=ancho-xx;
	z=yd;
	for(cc=yd;cc<y1;cc++)
		{
		pv=pvx+z*320+xd;
		for(c=xd;c<x1;c++)
			{
			 *pv=*base;
			 base++; pv++;
			}
		base+=zz;
		z++;
		}

 putfin:
 ;
}

void plot(int x,int y)
{
 if(x<320 && x>=0 && y<200 && y>=0)
	{
	pv=pvx+320*y+x;
	*pv=INK;
	}
}

int point(int x,int y)
{
 if(x<320 && x>=0 && y<200 && y>=0)
	{
	pv=pvx+320*y+x;
	return(*pv);
	}
  else {
	 return(255);
	}

}

void line(int x,int y,int xx,int yy)
{
 int z;

 if(x>xx){ z=x;x=xx;xx=z; }
 if(y>yy){ z=y;y=yy;yy=z; }
 if(x>=0 && y>=0 && xx>=0 && yy>=0)
	{
         pv=pvx+320*y+x;
	 if(xx==x && xx<320)  for(;y<=yy;y++){*pv=INK;pv+=320;}
	 if(yy==y)  {if(xx>319)xx=319; for(;x<=xx;x++){*pv=INK;pv++;}}

	}
}

void bar(int x,int y,int xx,int yy)
{
 int c,cc;

 if(x<320 && x>=0 && y<200 && y>=0 && xx<320 && xx>=0 && yy<200 && yy>=0)
 for(c=y;c<=yy;c++)
		{
		pv=pvx+320*c+x;
		for(cc=x;cc<=xx;cc++)
				{
				*pv=INK;
				pv++;
				}
		}
}
void box(int x,int y,int xx,int yy)
{
	line(x,y,xx,y);
	line(xx,y,xx,yy);
	line(xx,yy,x,yy);
	line(x,yy,x,y);
}
/* ------MOUSE ------ */
/* 0-borra cursor   1-mouse visible   2-oculta mouse   3-carga datos */
void mouse(int x)
{

  union REGS r;

  switch(x)
	{
	case 0: r.x.ax=0x0000;
		int86(0x33,&r,&r);
		if(r.x.ax==0)MOUSE=0; else MOUSE=r.x.bx;
		break;
	case 1: r.x.ax=0x0001;
		int86(0x33,&r,&r);
		break;
	case 2: r.x.ax=0x0002;
		int86(0x33,&r,&r);
		break;
	case 3: r.x.ax=0x0003;
		int86(0x33,&r,&r);
		XMOUSE=r.x.cx;
		YMOUSE=r.x.dx;
		KMOUSE=r.x.bx;
		CMOUSE=0;
		if(MX!=XMOUSE || MY!=YMOUSE || MK!=KMOUSE) CMOUSE=1;
		MX=XMOUSE; MY=YMOUSE; MK=KMOUSE;
		break;
	default: ;

	}
}
/* ------espera x segundos-------*/
void waits(unsigned int x)
{
 unsigned int ti,z;

 ti=time(NULL) ; z=ti; ti+=x ; while(ti-z>1) z=time(NULL);
}

/* --- 1=IMPRIME MOUSE    2=LEE MASCARA    3=ESCRIBE MASCARA --- */
void mouses (int x,int y,int t)
{
unsigned char c,z,zz;
pv=pvx+(x/2)+y*320;
zz=0;
if(MOUSE!=0)
{
 switch(t){
	case 1:
		for (z=0;z<64;z++)
		{
		 c=tmouse[z];
		 if(c!=0) *pv=c;
		 zz++;
		 if(zz==8){ pv+=312; zz=0;}
		 pv++;
		}
		break;
	case 2:
		for (z=0;z<64;z++)
		{
		 xmouse[z]=*pv;
		 zz++;
		 if(zz==8){ pv+=312; zz=0;}
		 pv++;
		}
		break;
	case 3:
		for (z=0;z<64;z++)
		{
		 *pv=xmouse[z];
		 zz++;
		 if(zz==8){ pv+=312; zz=0;}
		 pv++;
		}
		break;
	}
}
}
/* ---- LEE CADENA DEL TECLADO ----*/
void inputc(int x,int y,unsigned char nombre[40])
{
int z,zz,n;
	printc(x,y,nombre);
	for(z=0;z<40&&nombre[z]!=0;z++);
	x=x+(z<<3); z=x; n=0; zz=0;
	while(zz!=13)
		{
		 zz=inkey();
		 if(zz==13 || zz==27) goto fin;
		 if(zz!=0)
			{
			 if(zz==8)
				{
				 if(n!=0){z-=8;n--;impri(z,y,32);}
				}
				else
				{
				 impri(z,y,zz);
				 if(n<38){z+=8; VARI[n]=zz; n++;}
				}
			}
		}
fin:
	VARI[n]=0;

}

/* ---- LEE NUMERO DEL TECLADO ----*/
long inputn(int x,int y,unsigned char nombre[40])
{
	inputc(x,y,nombre);
	return(atol(VARI));
}

/* ------ Tratamiento de errores ----- */
void error(int z)
{
int m;
	m=dmode();
	mode(2);
	locate(0,0);
	switch(z)
		{
		 case 2:
			printf("Fichero no encontrado");
			break;
		 case 8:
			printf("Memoria insuficiente");
			break;
		 case 13:
			printf("Dato invalido");
			break;
		 default:
			printf("Error desconocido");
			break;
		}
	while(inkey()==0);
	mode(m);
}
