//PUZLE SDL__________________________________________
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <time.h>
#include <sys/time.h>

#include <SDL/SDL.h>
#include "SDL/SDL_ttf.h"
#include "SDL/SDL_image.h"
#include "SDL/SDL_mixer.h"

#include "main.h"
#include "xgrafi.h"
#include "define.h"


void Stimer();

void puntuarP(long pun);
int load_puntos(void);
long puntosMax[6];
char nombresMax[8][6];
long pu;


void Repaint(void);
unsigned int Ctime(void);
int inkeyM();
void printc(int x, int y, char* temp);
void printn(int x, int y, long temp);
void impri(int x, int y, char c);
char *inputc(int x, int y);

void Limpri(int x,int y, int c);
void Lclear(int c);
void Lputz(int zona,int xd,int yd,int xs,int ys, int xx, int yy);

void imprixxx(int xi, int yi, int xo, int yo, int w, int h);
void impriZone(int xi, int yi, int xo, int yo, int w, int h);

void printPun(void);
void presentacion(void);

#define ANCHO 12
#define ALTO 24
#define PIEZA 200
#define NOPIEZA 32
#define PARED 4
#define RX 12
#define RY 0

#define VELOCIDAD 40
unsigned int ti,ti1,velo,velo1;

void ipieza(int x,int y,int pi,int po,int c);
void ppieza(int x,int y ,int pi,int po,int c);
char gpieza(int x,int y ,int pi,int po);
void repintar(void);
void inicializar(void);
void avance();
void npieza();
void blinea();
void rotura(int y);

int t,pi,po,x,y,xx,yy,yy1,poo;
char cu[ANCHO+4][ALTO+4];
int nupieza[8];
char fi[168]={1,0,0,1,1,1, 1,0,0,1,1,1, 1,0,0,1,1,1, 1,0,0,1,1,1,
              -1,0,1,0,2,0, 0,-2,0,-1,0,1, -1,0,1,0,2,0, 0,-2,0,-1,0,1,
              -1,0,0,1,1,1, 0,-1,-1,0,-1,1, -1,0,0,1,1,1, 0,-1,-1,0,-1,1,
              1,0,-1,1,0,1, 0,-1,1,0,1,1, 1,0,-1,1,0,1, 0,-1,1,0,1,1,
			  0,-1,-1,0,1,0, 0,-1,-1,0,0,1, -1,0,1,0,0,1, 0,-1,1,0,0,1,
              -1,-1,-1,0,1,0, 0,-1,-1,1,0,1, -1,0,1,0,1,1, 0,-1,1,-1,0,1,
              1,-1,-1,0,1,0, -1,-1,0,-1,0,1, -1,0,1,0,-1,1, 0,-1,0,1,1,1};

int INK,PAPER;
struct PALETA {int r; int v; int a;};
static struct PALETA col[] = {
	 {0,0,0} ,{255,0,0}, {0,255,0}, {0,0,255}, {255,255,0},  
	 {255,0,255}, {0,255,255},  {127,255,255},  {255,127,127},  {255,255,255} };

//====================JUEGO=======================

int main (int argc, char *argv[])
{
  int quit = 0;
  int SimbolKey;
//  int mouse_x,mouse_y;

  if (init(320,240) == 0 ) return 1;
  printf("F1-Pantalla completa\nQ-Salir\nF12-Reinicio\n");

  if ( SDL_Flip( screen ) == -1 ) return 3;
  if (load_files((char*)"modelo2.jpg", (char*)"modelo1.png", (char*)"setam.ttf") == 0 ) return 2;
      
    load_puntos();
	puntuarP(0);
    inicializar();
  
 //__________JUEGO______________
INICIO:
	srand(time(NULL));
	presentacion();
	apply_surface( 0, 0, background, screen );
	inicializar();
	npieza();
	ti1=0;  pu=0;	velo=velo1=VELOCIDAD;
	y=0; 
	repintar();
  while ( quit == 0 )
  {
    SDL_Delay(20);
    //Stimer();
	avance();   
	if(y==0 && yy1!=300){ puntuarP(pu); goto INICIO;}
	if(xx!=x || y!=yy || po!=poo)
			{ ppieza(xx,yy,pi,poo,NOPIEZA);
			  if(1==gpieza(x,y,pi,po)){y=yy;x=xx;po=poo;}
			  ppieza(x,y,pi,po,PIEZA);
			  if((y&0x01)==1)
					Lputz(0,220+y*3,70,49,39,12,19);
				 else
					Lputz(0,220+y*3,70,33,39,12,19);
			}
	xx=x; yy=y; poo=po;

    while ( SDL_PollEvent( &event ) )
    {	  
      switch (event.type)
      {
//       case  SDL_KEYUP:
//          SimbolKey = event.key.keysym.sym;
//          break;
        case  SDL_KEYDOWN:
          SimbolKey = event.key.keysym.sym;
          switch (SimbolKey)
          {
			case  SDLK_q:
			  quit = 1;
			  break;
			case  SDLK_0:
			  Repaint();
			  break;
			  
			case  SDLK_7:
			  x--;
			  break;
			case  SDLK_8:
			  po++; if(po>4)po=1;
			  break;
			case  SDLK_9:
			  x++;
			  break;
			  
			case  SDLK_KP7:
			  x--;
			  break;
			case  SDLK_KP8:
			  po++; if(po>4)po=1;
			  break;
			case  SDLK_KP9:
			  x++;
			  break;
			  
			case  SDLK_LEFT:
			  x--;
			  break;
			case  SDLK_DOWN:
			  po++; if(po>4)po=1;
			  break;
			case  SDLK_RIGHT:
			  x++;
			  break;  			  
		  			  		
            case  SDLK_F1:
#if YesWindows
              screen = SDL_SetVideoMode( SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP, SDL_FULLSCREEN | SDL_SWSURFACE );
#else
              SDL_WM_ToggleFullScreen(screen);
#endif
              Repaint();
              break;
            case  SDLK_F2:
              screen = SDL_SetVideoMode( SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP, SDL_SWSURFACE );
              Repaint();
              break;
            case  SDLK_F5:
				Repaint();
              break;
            case  SDLK_F12:
              goto INICIO;
              break;
            case  SDLK_SPACE:
			  velo1=5;
			  break;	
          }

          break;
        case	SDL_MOUSEBUTTONDOWN: 
//			mouse_x=event.button.x;
//			mouse_y=event.button.y;	

	#ifdef DEBUG 
			printf("Evento Raton Abajo X=%d Y=%d \n",mouse_x,mouse_y);	
	#endif				
			if( event.button.button == SDL_BUTTON_LEFT ) 
				{	
					
				}			
        break;
        
        case  SDL_QUIT:
          quit = 1;
          break;
      }
    }

  }


  clean_up();
#ifdef DEBUG
  printf("Fin\n");
#endif
	screen = SDL_SetVideoMode( SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP, SDL_SWSURFACE );
  SDL_Delay(100);
  return 0;
}


//____________________

void avance()
{
	ti=Ctime();
	if(ti>ti1 || ti+1000<ti1)
		{
		 ti1=velo1+Ctime();		 
		 if(yy1==y)
		  {
		  ppieza(x,y,pi,po,NOPIEZA);
		  
		  if(1==gpieza(x,y+1,pi,po))
			{
			 ppieza(x,y,pi,po,PIEZA);
			 npieza();nupieza[pi]++; pu+=10; //printPun();
			 blinea();
			 velo1=velo=VELOCIDAD-pu/500;
			 if(velo<5)velo=velo1=10;
			 
			}
		   ppieza(x,y,pi,po,PIEZA);
		  }
		 yy1=y;
		 y++;
		 repintar(); 
		}
}

void repintar(void)
{
int z,zz,x,y;
char c;
	//printf("repintar\n");
	//Lclear(0);
	 for(zz=0;zz<ALTO;zz++)
			{
			  for(z=1;z<ANCHO-1;z++)
			  {
			   c=cu[z+2][zz+2];
			   if(c==NOPIEZA)
				{
				 INK=0;
				 Limpri((z+RX)<<3,(zz+RY)<<3,NOPIEZA);
				}
				else
				{
				 INK=c+1;
				 Limpri((z+RX)<<3,(zz+RY)<<3,PIEZA);
				}
			  }
			}
			
		INK=9;
		for(y=0;y<ALTO;y++)
			{
			 Limpri(RX<<3,y<<3,PARED);
			 Limpri((RX+ANCHO-1)<<3,y<<3,PARED);
			}
		for(x=0;x<ANCHO;x++)
			{
			 Limpri((RX+x)<<3,ALTO<<3,PARED);
			}
		printPun(); 
		Lputz(0,220,90,0,0,79,17);
		SDL_Flip(screen);
}

void rotura(int y)
{
int z;
	
	for(z=1;z<7;z++)
	{ SDL_Delay(25); Lputz(0,104,y*8,0,61,80,8); SDL_Delay(25);Lputz(0,104,y*8,0,68,80,8);}
	//sonido(100,50);
}

void ipieza(int x,int y,int pi,int po,int c)
{
int z;
		pi--; po--;
		z=pi*24+po*6;

		if(pi>9) pi=9;
		INK=pi+1;
		if(c==NOPIEZA) INK=0;

		Limpri(x<<3,y<<3,c);
		Limpri((x+fi[z])<<3,(y+fi[z+1])<<3,c);
		Limpri((x+fi[z+2])<<3,(y+fi[z+3])<<3,c);
		Limpri((x+fi[z+4])<<3,(y+fi[z+5])<<3,c);
		SDL_Flip(screen);
}

void blinea()
{
int z,zz,i;
	for(zz=2;zz<ALTO+2;zz++)
		{
		 i=0;
		 for(z=3;z<ANCHO+1;z++)  if(cu[z][zz]==NOPIEZA)i=1;
		 if(i==0)
			{
			 rotura(zz-2);
			 for(i=zz;i>1;i--) for(z=3;z<ANCHO+1;z++) cu[z][i]=cu[z][i-1];
			 pu+=100;  repintar();
			}
		}
}


void npieza()
{
		setcolor(0,0,0);
		bar(220,70,310,92);
		xx=x=ANCHO/2-1; yy=y=0; yy1=300;
		poo=po=1+rand()%4; pi=1+rand()%7;
//		printf("NUEVA x=%d  y=%d  po=%d  pi=%d\n",x,y,po,pi);
        nupieza[pi]++;
//		for(z=0;z<7;z++)printn(48,(z*3+1)<<3,nupieza[z+1]);
//		sonido(300,20);
}

char gpieza(int x,int y ,int pi,int po)
{
char c;
int z;		
		pi--; po--;
        z=pi*24+po*6;
		c=0;
		if(cu[x+2][y+2]!=NOPIEZA)c=1;
		if(cu[2+x+fi[z]][2+y+fi[z+1]]!=NOPIEZA)	c=1;
		if(cu[2+x+fi[z+2]][2+y+fi[z+3]]!=NOPIEZA) c=1;
		if(cu[2+x+fi[z+4]][2+y+fi[z+5]]!=NOPIEZA) c=1;
		return(c);
}

/* pi=pieza(1 a 5)  po=posicion(1 a 4) */
void ppieza(int x,int y,int pi,int po, int c)
{
int z,xx;
		xx=RX+x;
		ipieza(xx,y,pi,po,c);
        pi--; po--;
		z=pi*24+po*6;
		x+=2; y+=2;
		if(c==NOPIEZA) pi=NOPIEZA;
		cu[x][y]=pi;
		cu[x+fi[z]][y+fi[z+1]]=pi;
		cu[x+fi[z+2]][y+fi[z+3]]=pi;
		cu[x+fi[z+4]][y+fi[z+5]]=pi;
}

void inicializar(void)
{
int z,x,y;
		for(z=0;z<8;z++)nupieza[z]=0;
		for(x=0;x<ANCHO+4;x++)for(y=0;y<ALTO+4;y++)cu[x][y]=NOPIEZA;
		for(y=0;y<ALTO;y++)
			{
			 cu[2][y+2]=PARED; cu[ANCHO+1][y+2]=PARED;
			}
		for(x=0;x<ANCHO;x++)
			{
			 cu[x+2][ALTO+2]=PARED;
			}
}


void presentacion(void)
{
 int z;
	for(z=0;z<320;z+=5)
		{ 
		 Lclear(0); Lputz(0,100,z,0,0,79,17); SDL_Flip(screen); SDL_Delay(35);
		 if(z==100) SDL_Delay(2000);
		}
}


void printPun(void)
{
 int x=230,y=40;
	setcolor(0, 0, 0);
	bar(x,y,x+48,y+20);	
	setcolor(255, 255, 0);	
	printn(x,y,pu);
	setcolor(255, 0, 0);	
	printc(x-8,y-25,"PUNTOS");
}	


void Limpri(int x,int y, int c)
{
	if(INK>9) INK=9;
	setcolor(col[INK].r, col[INK].v, col[INK].a); 
	bar(x,y,x+7,y+7);
}	 

void Lclear(int c)
{	
	if(c>9) c=9;
	SDL_FillRect(screen,NULL,SDL_MapRGB(screen->format,col[c].r, col[c].v, col[c].a));
}

/*  ------------------------------------------------
	imprime una una parte de la zona (n) en pantalla
	xd,yd  cordendas de destino
	xs,ys  cordenadas de fuente
	xx,yy  tama¤o de la zona
*/
void Lputz(int zona,int xd,int yd,int xs,int ys, int xx, int yy)
{
  static SDL_Rect clip[ 1 ];
  clip[ 0 ].x = xs;
  clip[ 0 ].y = ys;
  clip[ 0 ].w = xx;
  clip[ 0 ].h = yy;
  apply_surfaceB( xd, yd, dots, screen, &clip[ 0 ] );	
} 



//______________________________FIN______________________

void Repaint(void)
{
//	Lclear(0);
	apply_surface( 0, 0, background, screen );
	repintar();
	SDL_Flip(screen);
}

void Stimer()
{
	ti=Ctime();	
	if( ti>ti1 || ti+2000<ti1 )	
		{
		 ti1=Ctime() + 100;
		 printf("Stimer\n");

		}
}

unsigned int Ctime(void)
{
 struct timeval tv;
 unsigned int z,zz;
	gettimeofday(&tv,NULL);
	z=tv.tv_usec/10000;
	zz=(tv.tv_sec & 0x00fff)*100;
	return(zz+z);
}

void impriZone(int xi, int yi, int xo, int yo, int w, int h)
{
  static SDL_Rect clip[ 1 ];
  clip[ 0 ].x = xi;
  clip[ 0 ].y = yi;
  clip[ 0 ].w = w;
  clip[ 0 ].h = h;
  apply_surfaceB( xo, yo, background, screen, &clip[ 0 ] );
}


void imprixxx(int xi, int yi, int xo, int yo, int w, int h)
{
  static SDL_Rect clip[ 1 ];
  clip[ 0 ].x = xi;
  clip[ 0 ].y = yi;
  clip[ 0 ].w = w;
  clip[ 0 ].h = h;
  apply_surfaceB( xo, yo, dots, screen, &clip[ 0 ] );
}


//______PUNTOS___________

int load_puntos(void)
{
 FILE *pf;
 int z;
 
  if ((pf = fopen("maxi.pun", "rb")) == NULL)
  {
    printf("ERROR en maxi.pun/n");
    return (2);
  }
  else
  {
    z = fread(puntosMax, 20, 1, pf);
    z += fread(nombresMax, 48, 1, pf); 
    fclose(pf);
  }
 return(0);
}

void puntuarP(long pun)
{
  int x, xx, z, c, cc;
  char temporal[20];
  FILE *pf;
  
  setcolor(0, 0, 0);
  bar(0, 0, 320, 240);

  if (pun > puntosMax[4] )
  {
    puntosMax[4] = pun;
    setcolor(0, 0, 0);        bar(0, 0, 320,240);
    setcolor(255, 255, 0);    printc(50, 40, (char*)"NOMBRE");
    SDL_Flip( screen );
    sprintf(temporal, "%s", inputc(70,60));
    for (c = 0; c < 8; c++) nombresMax[c][4] = 0;
    for (c = 0; c < 8 && temporal[c] != 0 ; c++) nombresMax[c][4] = temporal[c];
    nombresMax[7][4] = 0;
    for (xx = 4; xx > 0; xx--)
    {
      x = xx - 1;
      if (puntosMax[x] < puntosMax[x + 1])
      {
        puntosMax[5] = puntosMax[x];
        puntosMax[x] = puntosMax[x + 1];
        puntosMax[x + 1] = puntosMax[5];
        for (z = 0; z < 8; z++)
        {
          nombresMax[z][5] = nombresMax[z][x];
          nombresMax[z][x] = nombresMax[z][x + 1];
          nombresMax[z][x + 1] = nombresMax[z][5];
        }
      }
    }
    if ((pf = fopen("maxi.pun", "wb")) == NULL)
    {
      printf("Error archivo MAX.PUN");
    }
    else
    {
      z = fwrite(puntosMax, 20, 1, pf);
      z = fwrite(nombresMax, 48, 1, pf);
    }
    fclose(pf);

  }
  setcolor(0, 0, 0);
  bar(0, 0, 320, 240);
  setcolor(255, 0, 0);
  printc(50, 40, (char*)"MAXIMAS PUNTUACIONES");
  printc(50, 54, (char*)"====================");
  setcolor(255, 255, 0);
  SDL_Flip( screen );
  z = 2;
  for (x = 0; x < 5; x++)
  {
    z++;
    for (cc = 0; cc < 8; cc++)
    {
      impri((cc * 16 + 105), (x * 16 + 80), nombresMax[cc][x]);
    }
    printn((cc * 16 + 105), (x * 16 + 80), puntosMax[x]);
  }

  SDL_Flip( screen );
  SDL_Delay(5000);
}


//___________Rutinas basicas___________________
int inkeyM()
{
  int tecla;
  SDL_Delay(200);
  while ( SDL_PollEvent( &event ) )
  {
    switch (event.type)
    {
      case  SDL_KEYUP:
        tecla = event.key.keysym.sym;
        //            printf("Evento Tecla UP  %d \n",tecla);
        if (tecla > 96 && tecla < 123) tecla -= 32;
        return (tecla);
        break;
      case  SDL_QUIT:
        return (27);
        break;
    }
  }
  return (0);
}


//__________________________________

void printc(int x, int y, char* temp)
{
  SDL_Surface *message;
  message = TTF_RenderText_Solid( font, temp, ColorDefault );
  apply_surface( x, y, message, screen );
  SDL_FreeSurface(message); 
}

void printn(int x, int y, long temp)
{
  char VARI[20];
  sprintf(VARI, "%d", (int)temp);
  printc(x, y, VARI);
}

void impri(int x, int y, char c)
{
  char VARI[20];
  sprintf(VARI, "%c", c);
  printc(x, y, VARI);
}



/* ---- LEE CADENA DEL TECLADO ----*/

char *inputc(int x, int y)
{

  int zz, n;
  static char VARI[10];
  n = 0; zz = 0;
  while (zz != 10)
  {
    zz = inkeyM();
    if (zz == 13 || zz == 27) goto fin;
    if (zz != 0)
    {
      setcolor(0, 100, 0);
      bar(x, y, x + 100, y + 20);
      setcolor(255, 255, 255);
      if (zz == 8)
      {
        n--;
        if (n < 0)n = 0;
        VARI[n] = 0;
      }
      else
      {
        VARI[n] = zz; VARI[n + 1] = 0;
        if (n < 6)n++;
      }
      printc(x, y, VARI);
      SDL_Flip( screen );
    }
  }
fin:
  VARI[n] = 0;
  return (VARI);
}

