/* 
 * Manipulador morse MANI V2_pulsador_OLED
 * seta43
 * Juan Galaz
 * http: / / seta43.duckdns.org
 * http: / / seta43.blogspot.com 
 * 06/12/2025
*/



#define DEBUG 0
#define OLED_I2C  1
#define SIGNOS 0

/////////////////////////////////////////////////////////////////
//___________OLED_________
#include "olex.h"
#include <Wire.h>
/////////////////////////////////////////////////////////////////

char nombre[]="MORSE_ALL";

#define PIN_SOUND 9
#define TONO 647  //704

#define MILED 13
#define PUNTO 2
#define RAYA 3
#define MANI 4
#define PULSADOR 5

// letra,numero(punto  -raya),código
char cmorse[]{
    'A', 2, 0b01,    'B', 4, 0b1000,  'C', 4, 0b1010,  'D', 3, 0b100,
    'E', 1, 0b0,     'F', 4, 0b0010,  'G', 3, 0b110,   'H', 4, 0b0000,
    'I', 2, 0b00,    'J', 4, 0b0111,  'K', 3, 0b101,   'L', 4, 0b0100,
    'M', 2, 0b11,    'N', 2, 0b10,    'O', 3, 0b111,   'P', 4, 0b0110,
    'Q', 4, 0b1101,  'R', 3, 0b010,   'S', 3, 0b000,   'T', 1, 0b1,
    'U', 3, 0b001,   'V', 4, 0b0001,  'W', 3, 0b011,   'X', 4, 0b1001,
    'Y', 4, 0b1011,  'Z', 4, 0b1100,  '0', 5, 0b11111, '1', 5, 0b01111,
    '2', 5, 0b00111, '3', 5, 0b00011, '4', 5, 0b00001, '5', 5, 0b00000,
    '6', 5, 0b10000, '7', 5, 0b11000, '8', 5, 0b11100, '9', 5, 0b11110,
    '@', 4, 0b0011,  // borra pantalla
};

int VELOCIDAD;
char menuVelo=0;
int timeRaya ,timePunto ,timeLetra, timePalabra;
int cx;
char f1=0;
char f2=1;

int nPalabra=0;
char PALABRA[15];


int contador=0;
char DATA[10];

#define TIEMPO_LETRAS 3
char fx=0,Finicio=0;
int  tiempo,tiempo2,tiempo3, tiempoU=4000, tiempo3R;

char nsenal=0;
int SENAL[15];
char nvalor=0;
int VALOR[15];

int valorT=110,valorT3=340;

char cambio;
char caracter;
char rotaF;

char buffer[30];


void inicioMONO(void)
{ 
  Serial.println("\n\n\n");
  sprintf(buffer,"MONO PALA T=%d mS",valorT);  Serial.println(buffer);
  Serial.println("Cambiarlo con (......)"); 
  Serial.println("======================");

  #if OLED_I2C == 1 
    xclearDisplay();
    ModeFont=0;  xStringAT(0,0,buffer);
    cartel(0,0,0); cartel2(0,0,0);      
  #endif
}


void inicioBIPALA(void)
{

  VELOCIDAD=200-25*menuVelo;
  timeRaya =VELOCIDAD*3;
  timePunto =VELOCIDAD*1;
  timeLetra = VELOCIDAD*1;
  timePalabra =VELOCIDAD*7;

  Serial.println("\n\n\n");
  sprintf(buffer,"DOBLE PALA T=%d mS",timePunto);
  Serial.println(buffer);
  Serial.println("======================");
 
  #if OLED_I2C == 1  
    xclearDisplay(); 
    ModeFont=0; xStringAT(0,0,buffer); 
    cx=0;
    cartel(0,0,0);
  #endif

}





void setup() 
{
  Serial.begin(9600);
  pinMode(MILED, OUTPUT);
  pinMode(PUNTO, INPUT_PULLUP);
  pinMode(RAYA, INPUT_PULLUP);
  pinMode(PULSADOR, INPUT_PULLUP);
  pinMode(MANI, INPUT_PULLUP);

  #if OLED_I2C == 1   
    Wire.begin(); // I2C bus
    delay(200);  OleInit();  delay(100);
  #endif

  Serial.println("\n\n\n===SETA43====EA1FUD===");
  sprintf(buffer,"-.-.  %s  --.-",nombre); Serial.println(buffer);
  delay(1500);

  if(menuVelo==0)    
          inicioMONO();
      else
          inicioBIPALA();
}


void loop() 
{
 int zz;
   delay(1);
   tiempo++;  tiempo2++;  tiempo3++;
 
    if(LOW==digitalRead(PULSADOR) )
        {
          menuVelo++;
          if(menuVelo>5) menuVelo=0;
          for(zz=0;zz<menuVelo;zz++)  puntoE();
          if(menuVelo==0) {rayaE(); rayaE();}
          Serial.println((int) menuVelo);

          if(menuVelo==0)    
              inicioMONO();
          else
              inicioBIPALA();
          delay(500);
        }

    if(menuVelo==0)
        modoMONO();
      else
        modoBIPALA();
        
}





//====================================================
void modoBIPALA(void)
{
  int zz;
   if(tiempo2>timeLetra)
      {
        tiempo2=0;
        if(f2==0)
          {  
            caracter=buscar();   
            #if OLED_I2C == 1  
                cartel(1,caracter,4);  cartel2(1,caracter,7);
                rotaF=1;
                cx=0;
            #endif
            Serial.print(caracter);                    
            tone(PIN_SOUND, 2000);   delay(40);   noTone(PIN_SOUND);            
            contador=0;
            f2=1;
          }
      }
   
   if(tiempo>timePalabra)
      {
        tiempo=0;
        if(f1==0)
          {
            #if OLED_I2C == 1 
                cartel(1,' ',4);  cartel2(1,' ',7);
            #endif
            Serial.print("*");
            tiempo3R++; if(tiempo3R>10) {tiempo3R=0; Serial.println("");}
            tone(PIN_SOUND, 400);   delay(30);   noTone(PIN_SOUND);
            f1=1;
          }
      }

  
   if(LOW==digitalRead(PUNTO) )
    {
      puntoE();
      tiempo=0; tiempo2=0;
      f1=0; f2=0;
      DATA[contador]='.';
      if(contador<9) contador++;
    }
  
   if(LOW==digitalRead(RAYA) )
    {
      rayaE();
      tiempo=0; tiempo2=0;
      f1=0; f2=0;
      DATA[contador]='-';
      if(contador<9) contador++;
    }
}



void puntoE(void)
{
    digitalWrite(MILED,HIGH);
    tone(PIN_SOUND, TONO);
    delay(timePunto);
    noTone(PIN_SOUND);
    digitalWrite(MILED,LOW);
    #if SIGNOS == 1
      Serial.print(".");      
    #endif
    #if OLED_I2C == 1
      ModeFont=0; xStringAT(cx,2,".     "); cx++;
    #endif    
    delay(timePunto);
}

void rayaE(void)
{
    digitalWrite(MILED,HIGH);
    tone(PIN_SOUND, TONO);
    delay(timeRaya);
    noTone(PIN_SOUND);
    digitalWrite(MILED,LOW);
    #if SIGNOS == 1
      Serial.print("-");
    #endif    
    #if OLED_I2C == 1
      ModeFont=0; xStringAT(cx,2,"-     "); cx++;
    #endif   
    delay(timePunto);
}


//====================================================
void modoMONO(void)
{
 int zz;

   if(tiempo3>tiempoU+valorT3+valorT) //7T
      { 
        if(f1==0)
          {
            Serial.print("*");
            #if OLED_I2C == 1   
              if(rotaF==1) { cartel(1,' ',4);  cartel2(1,' ',7); rotaF=0;}
            #endif        
            tone(PIN_SOUND, 400);   delay(30);   noTone(PIN_SOUND); 
            tiempo3R++; if(tiempo3R>10) {tiempo3R=0; Serial.println("");}
            f1=1;
          }
        tiempo3=0;
      }
   if( tiempo3>tiempoU  && Finicio==1 )    
      { 
        for(zz=0;zz<nsenal;zz++)  VALOR[zz]=SENAL[zz+1]- SENAL[zz];
        contador=0;
        if(nsenal>11)
          {
            for(zz=0;zz<11;zz++) contador+= VALOR[zz];
            valorT=contador/11;
            valorT3=valorT*TIEMPO_LETRAS;  
            inicioMONO();
            tiempo3R=0;          
          }
        
        #if DEBUG == 1
            Serial.print(" "); Serial.print(valorT); Serial.print("<T  T3>"); Serial.println(valorT3);
            for(zz=0;zz<nsenal;zz++) { Serial.print(SENAL[zz]); Serial.print("< "); }
            Serial.println("***");
            for(zz=0;zz<nsenal-1;zz++) { Serial.print(VALOR[zz]); Serial.print("x ");  }         
            Serial.println("###");
        #endif

        contador=0;
        for(zz=0;zz<nsenal-1;zz+=2)
          {
            if( (VALOR[zz]-valorT/2)<valorT || (VALOR[zz]+valorT/2)<valorT )
              {
                DATA[contador]='.';
                if(contador<9) contador++;
                #if OLED_I2C == 1
                  ModeFont=0; xStringAT(cx,2,".     "); cx++;
                #endif
              }
              else
              {
                DATA[contador]='-';
                if(contador<9) contador++;
                #if OLED_I2C == 1
                  ModeFont=0; xStringAT(cx,2,"-     "); cx++;
                #endif                
              }
          } 
        cx=0;
        
        #if DEBUG == 1
            for(zz=0;zz<contador;zz++)  {  Serial.print((char) DATA[zz]);   }
        #endif  
        caracter=buscar();          
        Serial.print(caracter);
        #if OLED_I2C == 1  
            cartel(1,caracter,4);  cartel2(1,caracter,7);
            rotaF=1;
        #endif
        tone(PIN_SOUND, 2000);   delay(50);   noTone(PIN_SOUND);
                       
        Finicio=0;
        nsenal=0;
        tiempo3=0;
      }


    //=========================================
    if(cambio==0)
        {
              if(LOW==digitalRead(MANI) )
                {
                 if(fx==0)
                   {
                      digitalWrite(MILED,HIGH);
                      tone(PIN_SOUND, TONO);
                      cambio=1;
                      delay(10);
                      f1=0;
                   }
                  fx=1;
                }
                else
                {      
                  if(fx==1)
                  {
                     digitalWrite(MILED,LOW);
                     noTone(PIN_SOUND);
                     cambio=2;
                     delay(10);
                     f1=0;
                  }
                  fx=0;
                }
        }
    //===========================================  

  if(cambio!=0)
  {
    if(Finicio==0 && cambio==1) {   Finicio=1;  tiempo3=0;  }
    SENAL[nsenal]=tiempo3;
    if(cambio==1)
        tiempoU=tiempo3+3000;
      else
        tiempoU=tiempo3+valorT3;
    #if DEBUG == 1
        Serial.print(tiempoU); 
        Serial.print("*");
    #endif
    nsenal++;
    if(nsenal>14) nsenal=14;
    cambio=0;
  } 
}


//====================================================


char CARTEL[11];
//dire 0-borra  1-izquierda 
void cartel(char dire,char c,char y)
{
  int z;
  switch(dire)
  {
    case 0:
      for(z=0;z<10;z++) CARTEL[z]=32;
    break;

    case 1:
      for(z=0;z<10;z++) CARTEL[z]=CARTEL[z+1];
      CARTEL[9]=c;
      ModeFont=1;
      for(z=0;z<10;z++) xCaracterAT(z*2,y,CARTEL[z]);     
    break;
  }    
}


char CARTEL2[21];
//dire 0-borra  1-izquierda 
void cartel2(char dire,char c,char y)
{
  int z;
  switch(dire)
  {
    case 0:
      for(z=0;z<20;z++) CARTEL2[z]=32;
    break;

    case 1:
      for(z=0;z<20;z++) CARTEL2[z]=CARTEL2[z+1];
      CARTEL2[19]=c;
      ModeFont=0;
      for(z=0;z<20;z++) xCaracterAT(z,y,CARTEL2[z]);     
    break;
  }    
}



char buscar(void)
{
 int cue;
 int z,n,x,e,cx;

  for(z=0;z<109;z+=3)
    {
      if(contador==cmorse[z+1])
        {          
          cue=0;
          n=5-cmorse[z+1];
          x=cmorse[z+2]<<n;
          e=cmorse[z+1];
          while(e>0)
          {
            if( (x&16)==0)
                { if( DATA[cue]!='.') goto Salto1; }
               else
                { if( DATA[cue]!='-') goto Salto1; }
            x=x<<1;
            e--;
            cue++;
          }

          if(cmorse[z]=='@')   { inicioMONO();   return(' ');  }
        
          cx=0;
          return(cmorse[z]);

        }
Salto1:
      ;        
    }
    cx=0; 
    return('?');         
}
