//http://seta43.duckdns.org
//xsetaseta@gmail.com 
//09/03/2018
//OLED


#include <Wire.h>

#define OLE_LCDWIDTH                  128
#define OLE_LCDHEIGHT                 64

#define OLE_BUFFER  256

#define OLE_SETCONTRAST 0x81
#define OLE_DISPLAYALLON_RESUME 0xA4
#define OLE_DISPLAYALLON 0xA5
#define OLE_NORMALDISPLAY 0xA6
#define OLE_INVERTDISPLAY 0xA7
#define OLE_DISPLAYOFF 0xAE
#define OLE_DISPLAYON 0xAF

#define OLE_SETDISPLAYOFFSET 0xD3
#define OLE_SETCOMPINS 0xDA

#define OLE_SETVCOMDETECT 0xDB

#define OLE_SETDISPLAYCLOCKDIV 0xD5
#define OLE_SETPRECHARGE 0xD9

#define OLE_SETMULTIPLEX 0xA8

#define OLE_SETLOWCOLUMN 0x00
#define OLE_SETHIGHCOLUMN 0x10

#define OLE_SETSTARTLINE 0x40

#define OLE_MEMORYMODE 0x20
#define OLE_COLUMNADDR 0x21
#define OLE_PAGEADDR   0x22

#define OLE_COMSCANINC 0xC0
#define OLE_COMSCANDEC 0xC8

#define OLE_SEGREMAP 0xA0

#define OLE_CHARGEPUMP 0x8D

// Scrolling #defines
#define OLE_ACTIVATE_SCROLL 0x2F
#define OLE_DEACTIVATE_SCROLL 0x2E


// OLED display I2C address
#define OLED_ADDR   0x3C

unsigned char ModeFont=0;     //  Caracter de doble anchura



static const unsigned char ASCII[][5] =
{
 {0x00, 0x00, 0x00, 0x00, 0x00} // 20
,{0x00, 0x00, 0x5f, 0x00, 0x00} // 21 !
,{0x00, 0x07, 0x00, 0x07, 0x00} // 22 "
,{0x14, 0x7f, 0x14, 0x7f, 0x14} // 23 #
,{0x24, 0x2a, 0x7f, 0x2a, 0x12} // 24 $
,{0x23, 0x13, 0x08, 0x64, 0x62} // 25 %
,{0x36, 0x49, 0x55, 0x22, 0x50} // 26 &
,{0x00, 0x05, 0x03, 0x00, 0x00} // 27 '
,{0x00, 0x1c, 0x22, 0x41, 0x00} // 28 (
,{0x00, 0x41, 0x22, 0x1c, 0x00} // 29 )
,{0x14, 0x08, 0x3e, 0x08, 0x14} // 2a *
,{0x08, 0x08, 0x3e, 0x08, 0x08} // 2b +
,{0x00, 0x50, 0x30, 0x00, 0x00} // 2c ,
,{0x08, 0x08, 0x08, 0x08, 0x08} // 2d -
,{0x00, 0x60, 0x60, 0x00, 0x00} // 2e .
,{0x20, 0x10, 0x08, 0x04, 0x02} // 2f /
,{0x3e, 0x51, 0x49, 0x45, 0x3e} // 30 0
,{0x00, 0x42, 0x7f, 0x40, 0x00} // 31 1
,{0x42, 0x61, 0x51, 0x49, 0x46} // 32 2
,{0x21, 0x41, 0x45, 0x4b, 0x31} // 33 3
,{0x18, 0x14, 0x12, 0x7f, 0x10} // 34 4
,{0x27, 0x45, 0x45, 0x45, 0x39} // 35 5
,{0x3c, 0x4a, 0x49, 0x49, 0x30} // 36 6
,{0x01, 0x71, 0x09, 0x05, 0x03} // 37 7
,{0x36, 0x49, 0x49, 0x49, 0x36} // 38 8
,{0x06, 0x49, 0x49, 0x29, 0x1e} // 39 9
,{0x00, 0x36, 0x36, 0x00, 0x00} // 3a :
,{0x00, 0x56, 0x36, 0x00, 0x00} // 3b ;
,{0x08, 0x14, 0x22, 0x41, 0x00} // 3c <
,{0x14, 0x14, 0x14, 0x14, 0x14} // 3d =
,{0x00, 0x41, 0x22, 0x14, 0x08} // 3e >
,{0x02, 0x01, 0x51, 0x09, 0x06} // 3f ?
,{0x32, 0x49, 0x79, 0x41, 0x3e} // 40 @
,{0x7e, 0x11, 0x11, 0x11, 0x7e} // 41 A
,{0x7f, 0x49, 0x49, 0x49, 0x36} // 42 B
,{0x3e, 0x41, 0x41, 0x41, 0x22} // 43 C
,{0x7f, 0x41, 0x41, 0x22, 0x1c} // 44 D
,{0x7f, 0x49, 0x49, 0x49, 0x41} // 45 E
,{0x7f, 0x09, 0x09, 0x09, 0x01} // 46 F
,{0x3e, 0x41, 0x49, 0x49, 0x7a} // 47 G
,{0x7f, 0x08, 0x08, 0x08, 0x7f} // 48 H
,{0x00, 0x41, 0x7f, 0x41, 0x00} // 49 I
,{0x20, 0x40, 0x41, 0x3f, 0x01} // 4a J
,{0x7f, 0x08, 0x14, 0x22, 0x41} // 4b K
,{0x7f, 0x40, 0x40, 0x40, 0x40} // 4c L
,{0x7f, 0x02, 0x0c, 0x02, 0x7f} // 4d M
,{0x7f, 0x04, 0x08, 0x10, 0x7f} // 4e N
,{0x3e, 0x41, 0x41, 0x41, 0x3e} // 4f O
,{0x7f, 0x09, 0x09, 0x09, 0x06} // 50 P
,{0x3e, 0x41, 0x51, 0x21, 0x5e} // 51 Q
,{0x7f, 0x09, 0x19, 0x29, 0x46} // 52 R
,{0x46, 0x49, 0x49, 0x49, 0x31} // 53 S
,{0x01, 0x01, 0x7f, 0x01, 0x01} // 54 T
,{0x3f, 0x40, 0x40, 0x40, 0x3f} // 55 U
,{0x1f, 0x20, 0x40, 0x20, 0x1f} // 56 V
,{0x3f, 0x40, 0x38, 0x40, 0x3f} // 57 W
,{0x63, 0x14, 0x08, 0x14, 0x63} // 58 X
,{0x07, 0x08, 0x70, 0x08, 0x07} // 59 Y
,{0x61, 0x51, 0x49, 0x45, 0x43} // 5a Z
,{0x00, 0x7f, 0x41, 0x41, 0x00} // 5b [
,{0x02, 0x04, 0x08, 0x10, 0x20} // 5c ÃÂ¥
,{0x00, 0x41, 0x41, 0x7f, 0x00} // 5d ]
,{0x04, 0x02, 0x01, 0x02, 0x04} // 5e ^
,{0x40, 0x40, 0x40, 0x40, 0x40} // 5f _
,{0x00, 0x01, 0x02, 0x04, 0x00} // 60 `
,{0x20, 0x54, 0x54, 0x54, 0x78} // 61 a
,{0x7f, 0x48, 0x44, 0x44, 0x38} // 62 b
,{0x38, 0x44, 0x44, 0x44, 0x20} // 63 c
,{0x38, 0x44, 0x44, 0x48, 0x7f} // 64 d
,{0x38, 0x54, 0x54, 0x54, 0x18} // 65 e
,{0x08, 0x7e, 0x09, 0x01, 0x02} // 66 f
,{0x0c, 0x52, 0x52, 0x52, 0x3e} // 67 g
,{0x7f, 0x08, 0x04, 0x04, 0x78} // 68 h
,{0x00, 0x44, 0x7d, 0x40, 0x00} // 69 i
,{0x20, 0x40, 0x44, 0x3d, 0x00} // 6a j
,{0x7f, 0x10, 0x28, 0x44, 0x00} // 6b k
,{0x00, 0x41, 0x7f, 0x40, 0x00} // 6c l
,{0x7c, 0x04, 0x18, 0x04, 0x78} // 6d m
,{0x7c, 0x08, 0x04, 0x04, 0x78} // 6e n
,{0x38, 0x44, 0x44, 0x44, 0x38} // 6f o
,{0x7c, 0x14, 0x14, 0x14, 0x08} // 70 p
,{0x08, 0x14, 0x14, 0x18, 0x7c} // 71 q
,{0x7c, 0x08, 0x04, 0x04, 0x08} // 72 r
,{0x48, 0x54, 0x54, 0x54, 0x20} // 73 s
,{0x04, 0x3f, 0x44, 0x40, 0x20} // 74 t
,{0x3c, 0x40, 0x40, 0x20, 0x7c} // 75 u
,{0x1c, 0x20, 0x40, 0x20, 0x1c} // 76 v
,{0x3c, 0x40, 0x30, 0x40, 0x3c} // 77 w
,{0x44, 0x28, 0x10, 0x28, 0x44} // 78 x
,{0x0c, 0x50, 0x50, 0x50, 0x3c} // 79 y
,{0x44, 0x64, 0x54, 0x4c, 0x44} // 7a z
,{0x00, 0x08, 0x36, 0x41, 0x00} // 7b {
,{0x00, 0x00, 0x7f, 0x00, 0x00} // 7c |
,{0x00, 0x41, 0x36, 0x08, 0x00} // 7d }
,{0x10, 0x08, 0x08, 0x10, 0x08} // 7e 
//,{0x00, 0x06, 0x09, 0x09, 0x06} // 7f 
,{0, 7, 5, 7, 0} //Grados 127
//,{0x7f, 0x04, 0x09, 0x10, 0x7f} // Ñ 127
};



// SSD1306Z  contolado por I2C

void comando(unsigned char c) 
{ 
  // I2C
  unsigned char control = 0x00;   // Co = 0, D/C = 0
  Wire.beginTransmission(OLED_ADDR);
  Wire.write(control);
  Wire.write(c);
  Wire.endTransmission();
}

void OleInit(void)
{
    Wire.begin();
    Wire.setClock(100000);
    //Wire.setClock(400000);
  // Init sequence
  comando(OLE_DISPLAYOFF);                    // 0xAE
  comando(OLE_SETDISPLAYCLOCKDIV);            // 0xD5
  comando(0x80);                                  // the suggested ratio 0x80
  comando(OLE_SETMULTIPLEX);                  // 0xA8
  comando(63);
  comando(OLE_SETDISPLAYOFFSET);              // 0xD3
  comando(0x0);                                   // no offset
  comando(OLE_SETSTARTLINE | 0x0);            // line #0
  comando(OLE_CHARGEPUMP);                    // 0x8D

  comando(0x14);
  comando(OLE_MEMORYMODE);                    // 0x20
  comando(0x00);                                  // 0x0 act like ks0108
  comando(OLE_SEGREMAP | 0x1);
  comando(OLE_COMSCANDEC);

  comando(OLE_SETCOMPINS);                    // 0xDA
  comando(0x12);
  comando(OLE_SETCONTRAST);                   // 0x81
  comando(0xCF);
  comando(OLE_SETPRECHARGE);                  // 0xd9
  comando(0xF1);
  comando(OLE_SETVCOMDETECT);                 // 0xDB
  comando(0x40);
  comando(OLE_DISPLAYALLON_RESUME);           // 0xA4
  comando(OLE_NORMALDISPLAY);                 // 0xA6
  //comando(OLE_INVERTDISPLAY);
  comando(OLE_DEACTIVATE_SCROLL);
  comando(OLE_DISPLAYON);//--turn on oled panel
}



//Rutinas de texto
// SSD1306Z

void xCaracterAT(unsigned char x,unsigned char y,char character)
{
  int z,z1;
  unsigned char cx0,cx1;

  if(character==0) return;
  z1=character - 0x20;  
  x*=6;

  if( ModeFont==2)
  {
    //_______________________________
    comando(OLE_COLUMNADDR);
    comando(x);   // Column start address (0 = reset)
    comando(127);

    comando(OLE_PAGEADDR);
    comando(y); // Page start address (0 = reset)
    comando(y+1); // Page end address

    Wire.beginTransmission(OLED_ADDR);
    Wire.write(0x40);

    for (int index = 0; index < 5; index++)
    {
      cx0=0;
      z=ASCII[z1][index];
      if(z&1) cx0 |= 03;
      if(z&2) cx0 |=  12;
      if(z&4) cx0 |= 48;
      if(z&8) cx0 |= 192;
      Wire.write(cx0);
      Wire.write(cx0);
    }
    Wire.write(0);  
    Wire.endTransmission();

    comando(OLE_COLUMNADDR);
    comando(x);   // Column start address (0 = reset)
    comando(127);

    comando(OLE_PAGEADDR);
    comando(y+1); // Page start address (0 = reset)
    comando(y+2); // Page end address

    Wire.beginTransmission(OLED_ADDR);
    Wire.write(0x40);

    for (int index = 0; index < 5; index++)
    {
      cx1=0;
      z=ASCII[z1][index];
      if(z&16)cx1|=3;
      if(z&32)cx1|=12;
      if(z&64)cx1|=48;
      if(z&128)cx1|=192;
      Wire.write(cx1);
      Wire.write(cx1);
    }
    Wire.write(0);  
    Wire.endTransmission();
  }
  else
  {
    comando(OLE_COLUMNADDR);
    comando(x);   // Column start address (0 = reset)
    comando(127);

    comando(OLE_PAGEADDR);
    comando(y); // Page start address (0 = reset)
    comando(y+1); // Page end address

    Wire.beginTransmission(OLED_ADDR);
    Wire.write(0x40);
    for (unsigned char x=0; x<5; x++)
    {
      Wire.write(ASCII[z1][x]);
      if(ModeFont==1) Wire.write(ASCII[z1][x]);
    }
    Wire.write(0);  
    Wire.endTransmission();
  }
}

void xclearDisplay(void) 
{
  comando(OLE_COLUMNADDR);
  comando(0);   // Column start address (0 = reset)
  comando(127);

  comando(OLE_PAGEADDR);
  comando(0); // Page start address (0 = reset)
  comando(7); // Page end address

  // I2C
  for (uint16_t i=0; i<64; i++) 
  {
    // send a bunch of data in one xmission
    Wire.beginTransmission(OLED_ADDR);
    Wire.write(0x40);
    for (unsigned char x=0; x<16; x++) Wire.write(0);    
    Wire.endTransmission();
  }  

}

//Imprime cadena de caracteres
void xStringAT(unsigned char x,unsigned char y,  char *characters)
{
  while (*characters)
  {
    xCaracterAT(x,y, *characters++);
    x++;
    if(ModeFont==1 || ModeFont==2 ) x++;
  }

}
