/*
   seta43
   Juan Galaz
   http: / / seta43.duckdns.org
   http: / / seta43.blogspot.com
   2022
   Radio
*/


//#define DEBUG 1


//___________OLED_________
#include "olex.h"
#include <Wire.h>


int menu;
#define MAXmenu  4
int menux;
#define MAXmenux  4
static char* menuS[] = {" ", "Sintonia", "Volumen ", "Busqueda", "  INFO  "};



int volumen = 8, volumenOld = 7;
int frecuencia, frecuenciaOld;
int fre1, fre2;

unsigned int z, z1;
byte xfrecu, xfrecuOld;
unsigned int estado[6];


unsigned long time, time1, time2, time3, time4;

// int    RDA5807_adrs=0x10;       // I2C-Address RDA Chip for sequential  Access
// int    RDA5807_adrr=0x11;       // I2C-Address RDA Chip for random      Access
// int    RDA5807_adrt=0x60;       // I2C-Address RDA Chip for TEA5767like Access

unsigned int RDS[4];
char seg_RDS[9];
char seg_RDS1[65];
char indexRDS1;

char hora, minuto, grupo, versio;
unsigned long julian;

int mezcla;

char buffer[40];
char LINE0[22];
char LINE2[22];
char LINE3[22];
char LINE5[22];

char nombreE[10];


void setup()
{
  Wire.begin();
  Serial.begin(9600);

  WriteReg(0x02, 0xC00d); // write 0xC00d into Reg.2 ( soft reset, enable,RDS, )
  WriteReg(0x05, 0x84d8); // write ,0x84d8 into Reg.3

  // frecuencia inicial
  frecuencia = 165; //canal165 ->103.5MHz

  time3 = time2 = time1 = time = millis();
  menu = 3;

  canal(frecuencia);
  clearRDS;

  pinMode(5, INPUT);   pinMode(6, INPUT);   pinMode(7, INPUT);
  OleInit();
  xclearDisplay();
}

#define ESPERA 100

void loop()
{

  if ( HIGH == digitalRead(6))
  {
    menu++;    if (menu > MAXmenu)menu = 1;
#if DEBUG
    Serial.print("menu = " );  Serial.println(menu);
    Serial.println(menuS[menu]);
#endif
    ModeFont = 0; sprintf(buffer, "-%s-", menuS[menu]);  xStringAT(0, 7, buffer);
    while (HIGH == digitalRead(6))    delay(ESPERA);
  }

  if ( HIGH == digitalRead(5))
  {
    menux--;    if (menux < 1)menux = 1;
#if DEBUG
    Serial.print("<<menux = " );  Serial.println(menux);
#endif
    while (HIGH == digitalRead(5))    delay(ESPERA);
    switch (menu)
    {
      case 1:
        frecuencia--;
        if (frecuencia < 0)frecuencia = 0;
        delay(70);
        break;
      case 2:
        volumen--;
        if (volumen < 0)volumen = 0;
        break;
      case 3:
        clearRDS();
        busqueda(1);
        break;
      case 4:
        xclearDisplay();
        visualPI();
        visualPTY();
        delay(3000);
        xclearDisplay();
        //frecuenciaOld = -1;
        break;
    }
  }

  if ( HIGH == digitalRead(7))
  {
    menux++;    if (menux > MAXmenux)menux = MAXmenux;
#if DEBUG
    Serial.print("menux = " );  Serial.println(menux);
#endif
    while (HIGH == digitalRead(7))    delay(ESPERA);
    switch (menu)
    {
      case 1:
        frecuencia++;
        if (frecuencia > 205)frecuencia = 205;
        delay(70);
        break;
      case 2:
        volumen++;
        if (volumen > 15)volumen = 15;
        break;
      case 3:
        clearRDS();
        busqueda(0);
        break;
      case 4:
        xclearDisplay();
        visualPI();
        visualPTY();
        delay(3000);
        xclearDisplay();
        //frecuenciaOld = -1;
        break;
    }
  }




  if ( millis() - time1 > 1500)
  {
    ReadEstado();
    time1 = millis();
    //RDS
    if ((estado[0] & 0x8000) != 0) {
      get_RDS();
    }
  }

  if ( millis() - time3 > 2000)
  {
    time3 = millis();
    Visualizar();
  }

  if ( millis() - time4 > 50000)
  {
    time4 = millis();
    xclearDisplay();
    Visualizar();
  }

  //Cambio de frecuencia
  if ( frecuencia != frecuenciaOld)
  {
    frecuenciaOld = frecuencia;
    z = 870 + frecuencia;
#if DEBUG
    Serial.print("Frecuencia = " );  Serial.println(frecuencia);
#endif
    sprintf(buffer, "%3d.%d MHz  ", z / 10, z % 10);
    ModeFont = 1;   xStringAT(0, 0, buffer);
    canal(frecuencia);
    clearRDS();
    //Visualizar();
  }

  //Cambio de volumen
  if (volumen != volumenOld)
  {
    volumenOld = volumen;
    ModeFont = 0; sprintf(buffer, "Vol %02d", volumen);  xStringAT(0, 3, buffer);
    WriteReg(5, 0x84D0 | volumen);
  }

}





//_______________________________________________________________

void visualPI(void)
{
#if DEBUG
  Serial.print("PAIS:  "); Serial.println(RDS[0] >> 12 & 0X000F);
  Serial.print("Cobertura:"); Serial.println(RDS[0] >> 8 & 0X000F);
  Serial.print("CODIGO:"); Serial.println(RDS[0] & 0X00FF);
#endif

  ModeFont = 0;
  sprintf(buffer, "PAIS  -%02d", RDS[0] >> 12 & 0X000F); xStringAT(0, 0, buffer);
  sprintf(buffer, "COBERT-%02d", RDS[0] >> 8 & 0X000F); xStringAT(0, 1, buffer);
  sprintf(buffer, "CODIGO-%02d", RDS[0] & 0X00FF); xStringAT(0, 2, buffer);

}
void visualPTY(void)
{
#if DEBUG
  Serial.print("PTY:  "); Serial.println(RDS[1] >> 5 & 0X001F);
#endif

  xStringAT(0, 3, "PROGRAMA ");
  sprintf(buffer, "%02d", RDS[1] >> 5 & 0X001F); xStringAT(9, 3, buffer);

  for (z = 0; z < 20; z++)  {
    buffer[z] = seg_RDS1[z];
  }
  buffer[z] = 0;  xStringAT(0, 4, buffer);
  for (z = 0; z < 20; z++)  {
    buffer[z] = seg_RDS1[z + 20];
  }
  buffer[z] = 0;  xStringAT(0, 5, buffer);
  sprintf(buffer, "%3d.%d %3d.%d ", fre1 / 10, fre1 % 10, fre2 / 10, fre2 % 10); xStringAT(0, 7, buffer);

}


void busqueda(byte direc)
{
  byte i;
  if (!direc) WriteReg(0x02, 0xC30d); else  WriteReg(0x02, 0xC10d);

  for (i = 0; i < 10; i++)
  {
    delay(200);
    ReadEstado();
    if (estado[0] & 0x4000)
    {
#if DEBUG
      Serial.println("Emisora encontrada");
#endif
      frecuencia = estado[0] & 0x03ff;
      break;
    }
  }
}


void clearRDS(void)
{
  //borrar Name LCD Emisora
  sprintf(nombreE, "%17s", " ");
  for (z = 0; z < 9; z++)     seg_RDS[z] = 32;
  //Borrar TXT
  for (z = 0; z < 64; z++) seg_RDS1[z] = 32;
}

void Visualizar(void)
{
  int z, s;

  s = estado[1] >> 10;
  z = 870 + frecuencia;
  sprintf(LINE0, "%3d.%d MHz  ", z / 10, z % 10);
  sprintf(LINE2, "%.10s", nombreE);
  if ((estado[0] & 0x0400) == 0)
  {
    sprintf(LINE3, "Vol-%02d   Mono   S-%02d ", volumen, s);
  }
  else
  {
    sprintf(LINE3, "Vol-%02d  Stereo  S-%02d ", volumen, s);
  }
  for (z = 0; z < 21; z++)  {
    LINE5[z] = seg_RDS1[z];
  }
  LINE5[z] = 0;


#if DEBUG
  Serial.println("--VISUALIZAR--");
  Serial.println(LINE0);
  Serial.println(LINE2);
  Serial.println(LINE3);
  Serial.println(LINE5);
  Serial.println("--------------");
#endif

  ModeFont = 1;
  xStringAT(0, 0, LINE0);
  xStringAT(0, 2, LINE2);
  ModeFont = 0;
  xStringAT(0, 3, LINE3);
  xStringAT(0, 5, LINE5);

  sprintf(buffer, "-%s-", menuS[menu]);  xStringAT(0, 7, buffer);

}

void canal( int canal)
{
  byte numeroH, numeroL;

  numeroH =  canal >> 2;
  numeroL = ((canal & 3) << 6 | 0x10);
  Wire.beginTransmission(0x11);
  Wire.write(0x03);
  Wire.write(numeroH);                     // write frequency into bits 15:6, set tune bit
  Wire.write(numeroL);
  Wire.endTransmission();
}




//________________________
//RDA5807_adrr=0x11;
// I2C-Address RDA Chip for random      Access
void WriteReg(byte reg, unsigned int valor)
{
  Wire.beginTransmission(0x11);
  Wire.write(reg); Wire.write(valor >> 8); Wire.write(valor & 0xFF);
  Wire.endTransmission();
  //delay(50);
}

//RDA5807_adrs=0x10;
// I2C-Address RDA Chip for sequential  Access
int ReadEstado()
{
  Wire.requestFrom(0x10, 12);
  for (int i = 0; i < 6; i++) {
    estado[i] = 256 * Wire.read () + Wire.read();
  }
  Wire.endTransmission();

}




//READ RDS  Direccion 0x11 for random access
void ReadW()
{
  Wire.beginTransmission(0x11);            // Device 0x11 for random access
  Wire.write(0x0C);                                // Start at Register 0x0C
  Wire.endTransmission(0);                         // restart condition
  Wire.requestFrom(0x11, 8, 1);      // Retransmit device address with READ, followed by 8 bytes
  for (int i = 0; i < 4; i++) {
    RDS[i] = 256 * Wire.read() + Wire.read(); // Read Data into Array of Unsigned Ints
  }
  Wire.endTransmission();
}




void get_RDS()
{
  int i;


  ReadW();
  grupo = (RDS[1] >> 12) & 0xf;
  if (RDS[1] & 0x0800) versio = 1; else versio = 0; //Version A=0  Version B=1
  if (versio == 0)
  {
#if DEBUG
    sprintf(buffer, "Version=%d  Grupo=%02d ", versio, grupo); Serial.println(buffer);
#endif
    switch (grupo)
    {
      case 0:
        i = (RDS[1] & 3) << 1;
        seg_RDS[i] = (RDS[3] >> 8);
        seg_RDS[i + 1] = (RDS[3] & 0xFF);

        for (i = 0; i < 8; i++)
        {
          //Serial.print(seg_RDS[i],DEC); Serial.println("-"); Serial.println(seg_RDS[i]);
          if (seg_RDS[i] > 31 && seg_RDS[i] < 128)
            nombreE[i] = seg_RDS[i];
          else
            nombreE[i] = 32;
        }
        nombreE[8] = 0;


        fre1 = (RDS[2] >> 8) + 875;
        fre2 = (RDS[2] & 0xFF) + 875;
        break;

      case 2:
        i = (RDS[1] & 15) << 2;
        seg_RDS1[i] = (RDS[2] >> 8);
        seg_RDS1[i + 1] = (RDS[2] & 0xFF);
        seg_RDS1[i + 2] = (RDS[3] >> 8);
        seg_RDS1[i + 3] = (RDS[3] & 0xFF);
#if DEBUG
        Serial.println("_RADIOTEXTO_");
        for (i = 0; i < 44; i++)  Serial.write(seg_RDS1[i]);
        Serial.println("-TXT-");
#endif
        break;
      case 4:
        i = RDS[3] & 0x003f;
        minuto = (RDS[3] >> 6) & 0x003f;
        hora = (RDS[3] >> 12) & 0x000f;
        if (RDS[2] & 1) hora += 16;
        hora += i;
        z = RDS[2] >> 1;
        julian = z;

        if (RDS[1] & 1) julian += 32768;
        if (RDS[1] & 2) julian += 65536;
#if DEBUG
        Serial.print("_DATE_");
        Serial.print(" Juliano="); Serial.print(julian);
        Serial.println(buffer);
#endif
        break;
      default:
#if DEBUG
        Serial.println("_error_");
#endif
        ;
    }
  }
}
