/* 
 * seta43
 * Juan Galaz
 * http: / / seta43.duckdns.org
 * http: / / seta43.blogspot.com 
 * 2024
 * si5351
 * Arduino 1.8.19
 * Basada en: 10kHz to 120MHz VFO by CesarSound - ver 1.0 - Dec/2020.
*/


//#define DEBUG 1
char TITULO[]="--  SI5351  --";

//___________OLED_________
#include "olex.h"
#include  <Wire.h>                 //IDE Standard

#include <si5351.h>               //Etherkit  https://github.com/etherkit/Si5351Arduino

//User  preferences
//------------------------------------------------------------------------------------------------------------
#define FREQ_INIT  1000000   //Enter your initial frequency at startup,  ex: 7000000 = 7MHz, 10000000 = 10MHz, 840000 = 840kHz.
//------------------------------------------------------------------------------------------------------------

//__________ENCODER_______seta43_____
#define PIN_IN1 2
#define PIN_IN2 3
#define EBOTON 4
int D_encoder=0;
char D_e1=0,D_e2=2;

char mandoRotary(void)  // 1-IZQ  2-DER  3-BOTON
{
  
   if (LOW==digitalRead(EBOTON))   { delay(300); return(3);}
   if (D_e1==0) 
      {  if(HIGH==digitalRead(PIN_IN1)) { D_e1=1; if(D_e2==3) { D_encoder++; return(2);} }   }
      else
      {  if(LOW==digitalRead(PIN_IN1))  { D_e1=0; if(D_e2==2) { D_encoder++; return(2);} }   }
      
  if (D_e2==2) 
      {  if(HIGH==digitalRead(PIN_IN2)) { D_e2=3; if(D_e1==1) { D_encoder--; return(1);} }   }
      else
      {  if(LOW==digitalRead(PIN_IN2))  { D_e2=2; if(D_e1==0) { D_encoder--; return(1);} }   }
  return(0);
}
//_________________________________________

//_______________________________________
unsigned long freq = FREQ_INIT;
unsigned long fstep;
unsigned long long pll_freq = 90000000000ULL;
char stp_S[10];
#define FRE_MIN 10000
#define FRE_MAX 120000000

Si5351  si5351;


void setup() 
{
    Serial.begin(9600);
    delay(200);
    Wire.begin();

    Serial.println(TITULO);

    OleInit(); 
  
    pinMode(EBOTON,INPUT_PULLUP);
    pinMode(PIN_IN1,INPUT_PULLUP);
    pinMode(PIN_IN2,INPUT_PULLUP);

    bool i2c_found = si5351.init(SI5351_CRYSTAL_LOAD_8PF, 0, 0);
      if(!i2c_found)
      {
        Serial.println("Device not found on I2C bus!");
      }

    si5351.output_enable(SI5351_CLK0, 1);                  //1 - Enable  / 0 - Disable CLK
    si5351.output_enable(SI5351_CLK1, 0);
    si5351.output_enable(SI5351_CLK2,  0);
    si5351.drive_strength(SI5351_CLK0, SI5351_DRIVE_2MA);  //Output current  2MA, 4MA, 6MA or 8MA
   
    fstep = 10000;
    setstep();
    layout();
    displayPantalla();
    tunegen();
}



char cambio;
int tiempo;

void loop() 
{

  delay(1);
  tiempo++;
  if(tiempo>300)
  {
    tiempo=0;
     if(cambio!=0) { tunegen(); displayfreq(); cambio=0;}
  }

  
 
  switch(mandoRotary())
    {
      case 1:
        #ifdef DEBUG
          Serial.print(D_encoder);
          Serial.println(" IZQ ");
        #endif
        freq = freq - fstep; cambio=1;
      break;
      case 2:
        #ifdef DEBUG
        Serial.print(D_encoder);
        Serial.println(" DER ");
        #endif
        freq = freq + fstep;  cambio=1;
      break;
      case 3:
        #ifdef DEBUG
          Serial.println(" BOTON "); 
        #endif
        setstep();  displayPantalla();
      break;  
    }

}



void tunegen() 
{ 
  if (freq < FRE_MIN)  freq = FRE_MAX;
  if (freq > FRE_MAX) freq = FRE_MIN;
#ifdef DEBUG  
  Serial.print("-> ");Serial.println((long)freq); 
#endif  
  si5351.set_freq_manual(freq*100ULL, pll_freq, SI5351_CLK0);
}


void layout() 
{
  ModeFont=0; xStringAT(3,0,TITULO);
  ModeFont=2; xStringAT(0,5,stp_S);
}

void displayPantalla()
{
   displayfreq();
   layout();
}



void displayfreq() 
{
  unsigned int m = freq / 1000000;
  unsigned int k = (freq % 1000000) / 1000;
  unsigned int h = (freq % 1000) / 1;

 char buffer[20] = "";
 if(freq<100000000)
  {
    sprintf(buffer,"%02u.%03u.%03u",m,k,h);
    ModeFont=2; xStringAT(0,2,buffer);
  }
  else
  {
    ModeFont=2;
    sprintf(buffer,"%03u.%03u.%02u",m,k,h/10);
    xStringAT(0,2,buffer);
  }
  
#ifdef DEBUG
 Serial.print("    Display FRECU="); Serial.println(freq);
#endif 
}



void  setstep() 
{
  switch (fstep) 
  {
    case 1000000:
      fstep  = 1;      strcpy(stp_S,"1Hz");     
      break;
    case 1:
      fstep = 10;      strcpy(stp_S,"10Hz");
      break;
    case 10:
      fstep = 100;      strcpy(stp_S,"100Hz");
      break;
    case 100:
      fstep = 1000;      strcpy(stp_S,"1KHz");
      break;
    case 1000:
      fstep = 5000;      strcpy(stp_S,"5KHz");
      break;
    case 5000:
      fstep = 10000;      strcpy(stp_S,"10KHz");
      break;
    case 10000:
      fstep = 100000;      strcpy(stp_S,"100KHz");
      break;
    case 100000:
      fstep = 1000000;      strcpy(stp_S,"1MHz");
      break;

  }
  #ifdef DEBUG
    Serial.print(" PASOS="); Serial.println(fstep);
  #endif 
  xclearDisplay(); 
  layout();
}
