/* 
 * contador
 * Juan Galaz
 * seta43.duckdns.org
 * seta43.blogspot.com 
 * simulIDE  2021
*/

#define F_CPU 16000000L

#include <avr/io.h>          
#include <util/delay.h>

#include <stdio.h>


#define Set_Datos  			PORTB|=_BV(5)
#define Clear_Datos 			PORTB&=~_BV(5)
#define Set_Enable  			PORTB|=_BV(4)
#define Clear_Enable 			PORTB&=~_BV(4)

#define TIME_PULSO 25

void LCD_INI(void);
void LCD_CLS(void);
void LCD_HOME(void);
void LCD_AT(char x);
void Pon4bits(char x);
void ENABLE(void);
void SENDI(char x);
void SENDCHAR(char x);
void SENDCADE(char *x);
void PrintAtNum(unsigned char x,int numero);
void PrintAtStr(unsigned char x,char *string);

void MIdelay_ms(int z);
void MIdelay_us(int z);

char VARI[22];	//Modificar para numeros mayores de 16

int contador;

int main (void)
{
	PORTC=0X00;
	PORTB=0x00;
	PORTD=0x00;
	
	DDRD=0x0f; 	// puerto D como salida y entradas (output/input)
	DDRB=0xff; 	// puerto B como salida (output)
	DDRC=0xff; 	// puerto C como salida (output)	
	
	LCD_INI();
	LCD_CLS();
	LCD_HOME();

	LCD_AT(0);
	SENDCADE("simulIDE-avr-GCC");
            
	while(1)
		{	 
				 
				
			
			
			if( (PIND & 128))
				{
				 contador=0;	
				 PrintAtNum(74,contador); 
				}
			if( (PIND & 64))
				{
				 PORTD=PIND | 0B00000001;
				 PORTC=PINC | 0B00000010;
				 MIdelay_ms(50); 
				
				 contador++;
				
				 PrintAtNum(74,contador);
				 PORTD=PIND & 0b11111110;
				 PORTC=PINC & 0b11111101;
				 MIdelay_ms(50); 
				}				

		}
	return 0;            
}


//_____________________________________________________
  
void PrintAtStr(unsigned char x,char *string)
{
	LCD_AT(x);
	SENDCADE(string);
}
void PrintAtNum(unsigned char x,int numero)
{
	LCD_AT(x);
	sprintf(VARI,"%06d",numero);
	SENDCADE(VARI);
}
void LCD_INI(void)
{
	MIdelay_ms(250);
	Pon4bits(0x03);
	Clear_Datos;
	ENABLE();
	Set_Datos;
	MIdelay_ms(30);
	Pon4bits(0x03);
	Clear_Datos;
	ENABLE();
	Set_Datos;
	MIdelay_ms(30);
	Pon4bits(0x03);
	Clear_Datos;
	ENABLE();
	Set_Datos;
	MIdelay_ms(30);

	Pon4bits(0x02); // modo 4 bits
	Clear_Datos;
	ENABLE();
	Set_Datos;
		
	SENDI(0x2c); //modo 4 bits, dos lineas
	SENDI(0x0f); // cursor con parpadeo
	//SENDI(0x04);	//modo decremento
	SENDI(0x06); 	//modo incremento
	
}

void Pon4bits(char x)
{
 char z;
 z=PORTB & 0xf0;
 x= x & 0x0f;
 PORTB= x |z;
}
void LCD_CLS(void)
{
	SENDI(1); //borra pantalla
}
void LCD_HOME(void)
{
	SENDI(2); //cursor al inicio
}
void LCD_AT(char x) //0 Comienzo línea1, 64 Comienzo línea2
{
	x=x | 128;
	SENDI(x);
}
void SENDCADE(char *x)
{
 char z;
	for(z=0;z<33 && *x!=0;z++,x++)
		{SENDCHAR(*x);}	
}
void SENDCHAR(char x)
{
 char z;
	z=x >> 4;
	Pon4bits(z); //4 bytes de mas peso
	ENABLE();
	Pon4bits(x); //4 bytes de menos peso
	ENABLE();
}
//Manda datos de control
void SENDI(char x)
{
	Clear_Datos;
	SENDCHAR(x);
	_delay_us(TIME_PULSO);
	//MIdelay_us(TIME_PULSO); //Tiempos para reformar
	Set_Datos;
}
void ENABLE(void)
{
	Set_Enable;
	_delay_us(TIME_PULSO);
	//MIdelay_us(TIME_PULSO); //Tiempos para reformar
	Clear_Enable;
}


void MIdelay_ms(int z)
{
	while(z>0)
	{
		_delay_ms(1);
		z--;
	}
}



