/* 
 * semaforo
 * Juan Galaz
 * seta43.duckdns.org
 * seta43.blogspot.com 
 * simulIDE  2021
*/

#define F_CPU 16000000L

#include <avr/io.h>          
#include <util/delay.h>


//__________________ tiempos Semaforo____
#define  srojo 5		//S
#define  samarillo 2000	//mS
#define  sverde 4			//S
#define  sparpadeo 500		//mS


void delaySec(int sec)
{
	while(sec>0)
	{
	 sec--;
	 _delay_ms(1000);
	}
}

void semaforoRojo(void)
{	
	PORTB=PINB & 0B11110000;
	PORTB=PINB | 0B00001000;
}

void semaforoAmarillo(void)
{
	PORTB=PINB & 0B11110000;
	PORTB=PINB | 0B00000100;
}

void semaforoVerde(void)
{
	PORTB=PINB & 0B11110000;
	PORTB=PINB | 0B00000010;
}

void peatonVerde(void)
{
	PORTB=PINB & 0B11001110;
	PORTB=PINB | 0B00010000;
}

void peatonRojo(void)
{
	PORTB=PINB & 0B11001110;
	PORTB=PINB | 0B00100000;
}

void peatonApagado(void)
{
	PORTB=PINB & 0B11001110;
	PORTB=PINB | 0B00000000;
}

void peatonParpadeo(int z)
{
	while(z>0)
		{
			z--;		
			 peatonVerde();
			_delay_ms(sparpadeo);
			 peatonApagado();
			_delay_ms(sparpadeo);
		}
	peatonApagado();
	_delay_ms(sparpadeo);
}


int main (void)
{
	PORTC=0X00;
	PORTB=0x00;
	PORTD=0x00;
	
	DDRB=0xff; 	// puerto B como salida (output)
	
	while(1)
	{
		semaforoAmarillo();
		_delay_ms(samarillo);
		semaforoRojo();
		_delay_ms(samarillo);
		peatonVerde();
		delaySec(srojo);		
		peatonParpadeo(6);
		peatonRojo();
		semaforoVerde();
		delaySec(sverde);	
	}

 return(0);

}